/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.session.SessionLoaderImpl1;
import fi.csc.microarray.client.session.SessionLoaderImpl2;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.XmlUtil;
import fi.csc.microarray.util.ZipUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import org.w3c.dom.Document;

public class SessionLoader {
    private DataManager dataManager;
    private File sessionFile;
    private String sessionId;
    private boolean isDatalessSession;
    private Integer xOffset;
    private String sessionNotes;
    private List<OperationRecord> unfinishedJobs;

    public SessionLoader(File sessionFile, boolean isDatalessSession, DataManager dataManager) throws MicroarrayException {
        this.sessionFile = sessionFile;
        this.sessionId = null;
        this.dataManager = dataManager;
        this.isDatalessSession = isDatalessSession;
    }

    public SessionLoader(String sessionId, DataManager dataManager) throws MicroarrayException {
        this.sessionFile = null;
        this.sessionId = sessionId;
        this.dataManager = dataManager;
        this.isDatalessSession = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSession() throws Exception {
        Object impl;
        ZipFile zipFile = null;
        InputStreamReader metadataReader = null;
        String version = Integer.toString(UserSession.SESSION_VERSION);
        try {
            if (this.sessionFile != null) {
                zipFile = new ZipFile(this.sessionFile);
                metadataReader = new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("session.xml")));
                Document doc = XmlUtil.parseReader(metadataReader);
                version = doc.getDocumentElement().getAttribute("format-version");
            }
        }
        finally {
            IOUtils.closeIfPossible(metadataReader);
            ZipUtils.closeIfPossible(zipFile);
        }
        if (Integer.toString(UserSession.PREVIOUS_SESSION_VERSION).equals(version)) {
            impl = new SessionLoaderImpl1(this.sessionFile, this.dataManager, this.isDatalessSession);
            ((SessionLoaderImpl1)impl).loadSession();
            return;
        }
        impl = this.sessionFile != null ? new SessionLoaderImpl2(this.sessionFile, this.dataManager, this.isDatalessSession) : new SessionLoaderImpl2(this.sessionId, this.dataManager, this.isDatalessSession);
        ((SessionLoaderImpl2)impl).setXOffset(this.xOffset);
        ((SessionLoaderImpl2)impl).loadSession();
        this.sessionNotes = ((SessionLoaderImpl2)impl).getSessionNotes();
        this.unfinishedJobs = ((SessionLoaderImpl2)impl).getUnfinishedOperations();
    }

    public void setXOffset(Integer xOffset) {
        this.xOffset = xOffset;
    }

    public String getSessionNotes() {
        return this.sessionNotes;
    }

    public List<OperationRecord> getUnifinishedJobs() {
        return this.unfinishedJobs;
    }
}

