/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.serverfiles.ServerFileSystemView;
import fi.csc.microarray.client.serverfiles.ServerFileUtils;
import fi.csc.microarray.client.session.RemoteSessionAccessory;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerException;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.swing.JFileChooser;

public class RemoteSessionChooserFactory {
    private SwingClientApplication app;

    public RemoteSessionChooserFactory(SwingClientApplication app) {
        this.app = app;
    }

    private JFileChooser populateFileChooserFromServer() throws JMSException, Exception, MalformedURLException {
        return this.populateFileChooserFromServer(true);
    }

    private JFileChooser populateFileChooserFromServer(boolean excludeExampleSessions) throws JMSException, Exception, MalformedURLException {
        JFileChooser sessionFileChooser = new JFileChooser();
        sessionFileChooser.setMultiSelectionEnabled(false);
        RemoteSessionChooserFactory.updateRemoteSessions(this.app.getSessionManager(), sessionFileChooser, excludeExampleSessions);
        this.app.fixFileChooserFontSize(sessionFileChooser);
        return sessionFileChooser;
    }

    public static ServerFileSystemView updateRemoteSessions(SessionManager sessionManager, JFileChooser sessionFileChooser, boolean excludeExampleSessions) throws FileBrokerException, MalformedURLException {
        List<DbSession> sessions = sessionManager.listRemoteSessions();
        if (excludeExampleSessions) {
            LinkedList<DbSession> sessionsToHide = new LinkedList<DbSession>();
            for (DbSession session : sessions) {
                if (!session.getName().startsWith("Example sessions")) continue;
                sessionsToHide.add(session);
            }
            sessions.removeAll(sessionsToHide);
        }
        ServerFileSystemView view = ServerFileSystemView.parseFromPaths("Cloud sessions", sessions);
        sessionFileChooser.setFileSystemView(view);
        sessionFileChooser.setCurrentDirectory(null);
        sessionFileChooser.setCurrentDirectory(view.getRoot());
        sessionFileChooser.putClientProperty("sessions", sessions);
        sessionFileChooser.updateUI();
        return view;
    }

    public JFileChooser getExampleSessionChooser() throws MalformedURLException, JMSException, Exception {
        JFileChooser exampleSessionFileChooser = this.populateFileChooserFromServer(false);
        exampleSessionFileChooser.setSelectedFile(new File("session"));
        ServerFileUtils.hideJFileChooserButtons(exampleSessionFileChooser);
        exampleSessionFileChooser.setPreferredSize(new Dimension(800, 600));
        ServerFileSystemView view = (ServerFileSystemView)exampleSessionFileChooser.getFileSystemView();
        exampleSessionFileChooser.setCurrentDirectory(view.getExampleSessionDir());
        return exampleSessionFileChooser;
    }

    public JFileChooser getRemoteSessionChooser() throws MalformedURLException, JMSException, Exception {
        JFileChooser remoteSessionFileChooser = this.populateFileChooserFromServer();
        remoteSessionFileChooser.setSelectedFile(new File("session"));
        remoteSessionFileChooser.setPreferredSize(new Dimension(800, 600));
        remoteSessionFileChooser.setAccessory(new RemoteSessionAccessory(remoteSessionFileChooser, this.app.getSessionManager(), this.app));
        ServerFileUtils.hideJFileChooserButtons(remoteSessionFileChooser);
        return remoteSessionFileChooser;
    }

    public JFileChooser getManagementChooser() {
        JFileChooser sessionFileChooser = null;
        try {
            sessionFileChooser = this.populateFileChooserFromServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sessionFileChooser.setDialogTitle("Manage");
        sessionFileChooser.setPreferredSize(new Dimension(800, 600));
        sessionFileChooser.setAccessory(new RemoteSessionAccessory(sessionFileChooser, this.app.getSessionManager(), this.app));
        ServerFileUtils.hideJFileChooserButtons(sessionFileChooser);
        ServerFileUtils.hideApproveButton(sessionFileChooser);
        ServerFileUtils.setCancelButtonText(sessionFileChooser, "Close");
        return sessionFileChooser;
    }
}

