/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Strings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OperationDefinition
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(OperationDefinition.class);
    public static final String IMPORT_DEFINITION_ID = "operation-definition-id-import";
    public static final String CREATE_DEFINITION_ID = "operation-definition-id-user-modification";
    public static final OperationDefinition IMPORT_DEFINITION;
    public static final OperationDefinition CREATE_DEFINITION;
    public static String IDENTIFIER_SEPARATOR;
    private String id;
    private String displayName;
    private ToolCategory category;
    private LinkedList<Parameter> parameters = new LinkedList();
    private String description;
    private String helpURL;
    private int colorCount;
    private int outputCount = 0;
    private LinkedList<InputDefinition> inputs = new LinkedList();
    private boolean hasSourceCode;
    private boolean isLocal = false;

    public OperationDefinition(String id, String displayName, ToolCategory category, String description, boolean hasSourceCode, String helpURL) {
        this.id = id;
        this.displayName = displayName;
        this.category = category;
        this.hasSourceCode = hasSourceCode;
        this.helpURL = helpURL;
        if (category != null) {
            category.addOperation(this);
        }
        this.description = description;
    }

    public OperationDefinition(String id, String displayName, ToolCategory category, String description, boolean hasSourceCode, String helpURL, boolean isLocal) {
        this(id, displayName, category, description, hasSourceCode, helpURL);
        this.isLocal = isLocal;
    }

    public OperationDefinition(String id, String displayName, ToolCategory category, String description, boolean hasSourceCode) {
        this(id, displayName, category, description, hasSourceCode, null);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public ToolCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCategoryName() {
        return this.category.getName();
    }

    public String getFullName() {
        return this.getCategoryName() + " / " + this.getDisplayName();
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public Suitability evaluateSuitabilityFor(Iterable<DataBean> data, List<Operation.DataBinding> bindings) {
        if (bindings == null) {
            BindingResult result = this.bindInputs(data);
            return result.suitability;
        }
        return this.evaluateBindingSuitability(data, bindings);
    }

    public Suitability evaluateBindingSuitability(Iterable<DataBean> datas, List<Operation.DataBinding> bindings) {
        for (InputDefinition input : this.inputs) {
            if (input.isOptional() || this.bindingsContainsInput(bindings, input)) continue;
            logger.debug((Object)("  no binding found for " + input.getID()));
            return Suitability.EMPTY_REQUIRED_PARAMETERS;
        }
        HashSet<DataBean> boundDatas = new HashSet<DataBean>();
        for (Operation.DataBinding binding : bindings) {
            boundDatas.add(binding.getData());
        }
        if (!this.inputs.isEmpty()) {
            for (DataBean data : datas) {
                if (boundDatas.contains(data)) continue;
                logger.debug((Object)("  concrete input " + data.getName() + " was not bound"));
                return Suitability.EMPTY_REQUIRED_PARAMETERS;
            }
        }
        return Suitability.SUITABLE;
    }

    private boolean bindingsContainsInput(List<Operation.DataBinding> bindings, InputDefinition input) {
        for (Operation.DataBinding binding : bindings) {
            if (!input.idMatches(binding.getName())) continue;
            return true;
        }
        return false;
    }

    public static Suitability evaluateParameterSuitability(List<Parameter> params) {
        for (Parameter param : params) {
            if (param.isOptional() || param.getValue() != null && !param.getValue().equals("")) continue;
            return Suitability.EMPTY_REQUIRED_PARAMETERS;
        }
        return Suitability.SUITABLE;
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String id) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getID().equals(id)) continue;
            return parameter;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void addInput(SADLDescription.Name name, String description, SADLSyntax.InputType type, boolean isOptional) {
        InputDefinition input = new InputDefinition(name, description, type, isOptional);
        this.inputs.add(input);
    }

    public void addInput(String prefix, String postfix, String displayName, String description, SADLSyntax.InputType type, boolean isOptional) {
        InputDefinition input = new InputDefinition(prefix, postfix, displayName, description, type, isOptional);
        this.inputs.add(input);
    }

    public List<InputDefinition> getInputs() {
        return this.inputs;
    }

    public InputDefinition getInput(String id) {
        for (InputDefinition input : this.inputs) {
            if (!input.idMatches(id)) continue;
            return input;
        }
        return null;
    }

    public BindingResult bindInputs(Iterable<DataBean> inputValues) {
        BindingResult result = new BindingResult();
        LinkedList<Operation.DataBinding> bindings = new LinkedList<Operation.DataBinding>();
        LinkedList<DataBean> notProcessedInputValues = new LinkedList<DataBean>();
        for (DataBean dataBean : inputValues) {
            notProcessedInputValues.add(dataBean);
        }
        LinkedList<InputDefinition> unboundMetadataDefinitions = new LinkedList<InputDefinition>();
        logger.debug((Object)("binding " + notProcessedInputValues.size() + " values to " + this.inputs.size() + " formal inputs"));
        for (InputDefinition input : this.inputs) {
            input.resetMulti();
            if (this.doBackwardsCompatibleMetadataCheck(input)) {
                unboundMetadataDefinitions.add(input);
                continue;
            }
            LinkedList<DataBean> removedValues = new LinkedList<DataBean>();
            for (DataBean value : notProcessedInputValues) {
                logger.debug((Object)("  trying to bind " + value.getName() + " to " + input.id + " (" + input.type + ")"));
                if (!this.doBackwardsCompatibleTypeCheck(input.type, value)) continue;
                logger.debug((Object)("    bound successfully (" + value.getName() + " -> " + input.getID() + ")"));
                bindings.add(new Operation.DataBinding(value, input.getID(), input.getType()));
                removedValues.add(value);
                if (!input.isMulti()) break;
                input.nextMulti();
            }
            notProcessedInputValues.removeAll(removedValues);
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings before metadata retrieval"));
        if (!unboundMetadataDefinitions.isEmpty()) {
            LinkedList<Operation.DataBinding> linkedList = new LinkedList<Operation.DataBinding>();
            Iterator bindingIterator = bindings.iterator();
            Iterator unboundMetadataIterator = unboundMetadataDefinitions.iterator();
            while (bindingIterator.hasNext() && unboundMetadataIterator.hasNext()) {
                DataBean input = ((Operation.DataBinding)bindingIterator.next()).getData();
                InputDefinition unboundMetadata = (InputDefinition)unboundMetadataIterator.next();
                DataBean metadata = LinkUtils.retrieveInherited(input, DataBean.Link.ANNOTATION);
                if (metadata != null) {
                    linkedList.add(new Operation.DataBinding(metadata, unboundMetadata.getID(), ChipsterInputTypes.PHENODATA));
                    continue;
                }
                result.suitability = Suitability.IMPOSSIBLE;
                return result;
            }
            bindings.addAll(linkedList);
        }
        logger.debug((Object)("we have " + bindings.size() + " bindings after metadata retrieval"));
        if (!this.evaluateBindingSuitability(inputValues, bindings).isOk()) {
            result.suitability = Suitability.IMPOSSIBLE;
            return result;
        }
        result.bindings = bindings;
        result.suitability = Suitability.SUITABLE;
        return result;
    }

    private boolean doBackwardsCompatibleTypeCheck(SADLSyntax.InputType type, DataBean data) {
        if (type.equals(ChipsterInputTypes.AFFY)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.RAW_AFFYMETRIX_EXPRESSION_VALUES);
        }
        if (type.equals(ChipsterInputTypes.CDNA)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.RAW_EXPRESSION_VALUES);
        }
        if (type.equals(ChipsterInputTypes.GENE_EXPRS)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.NORMALISED_EXPRESSION_VALUES);
        }
        if (type.equals(ChipsterInputTypes.GENELIST)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.GENENAMES);
        }
        if (type.equals(ChipsterInputTypes.BAM)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.BAM_FILE);
        }
        if (type.equals(ChipsterInputTypes.FASTA)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.FASTA_FILE);
        }
        if (type.equals(ChipsterInputTypes.GTF)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.GTF_FILE);
        }
        if (type.equals(ChipsterInputTypes.PHENODATA)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.PHENODATA);
        }
        if (type.equals(GenericInputTypes.GENERIC)) {
            return true;
        }
        if (type.equals(ChipsterInputTypes.MOTHUR_OLIGOS)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.MOTHUR_OLIGOS);
        }
        if (type.equals(ChipsterInputTypes.MOTHUR_NAMES)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.MOTHUR_NAMES);
        }
        if (type.equals(ChipsterInputTypes.MOTHUR_GROUPS)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.MOTHUR_GROUPS);
        }
        if (type.equals(ChipsterInputTypes.MOTHUR_STABILITY)) {
            return data.hasTypeTag(MicroarrayModule.TypeTags.MOTHUR_STABILITY);
        }
        throw new IllegalArgumentException();
    }

    private boolean doBackwardsCompatibleMetadataCheck(InputDefinition input) {
        return input.id.startsWith("phenodata");
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public String toStringVerbose() {
        String s = "\n-------------- operation definition --------------\n";
        s = s + this.getCategoryName() + " / ";
        s = s + this.getDisplayName() + " ";
        s = s + "(" + this.getID() + ")\n";
        for (InputDefinition input : this.inputs) {
            String type = input.getType() != null ? input.getType().getName() : "null";
            s = s + input.getID() + " " + type + " " + input.getDescription() + "\n";
        }
        for (Parameter parameter : this.parameters) {
            String value = parameter.getValue() == null ? "[no default value]" : parameter.getValueAsString();
            s = s + parameter.getID() + " " + value + "\n";
        }
        s = s + "\n-------------- operation definition --------------\n";
        return s;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isBatchable() {
        for (Parameter parameter : this.parameters) {
            if (!parameter.isInputSensitive()) continue;
            return false;
        }
        return this.inputs.size() == 1;
    }

    public String getParameterDefaultValue(OperationRecord.ParameterRecord parameterRecord) {
        Parameter parameter = this.getParameter(parameterRecord.getNameID().getID());
        String defaultValue = null;
        if (parameter != null) {
            defaultValue = parameter.getValueAsString();
        }
        return defaultValue;
    }

    public String getHumanReadableParameterValue(OperationRecord.ParameterRecord parameterRecord) {
        EnumParameter enumParameter;
        Object[] options;
        Parameter parameter = this.getParameter(parameterRecord.getNameID().getID());
        if (parameter instanceof EnumParameter && (options = (enumParameter = (EnumParameter)parameter).getOptions()) != null) {
            for (Object choice : options) {
                EnumParameter.SelectionOption option = (EnumParameter.SelectionOption)choice;
                if (!parameterRecord.getValue().equals(option.getValue())) continue;
                return option.toString();
            }
        }
        return parameterRecord.getValue();
    }

    static {
        IDENTIFIER_SEPARATOR = "/";
        IMPORT_DEFINITION = new OperationDefinition(IMPORT_DEFINITION_ID, "Import data", ToolCategory.IMPORT_CATEGORY, "Import data.", false, null);
        CREATE_DEFINITION = new OperationDefinition(CREATE_DEFINITION_ID, "Create a dataset", ToolCategory.CREATE_CATEGORY, "Create a new dataset.", false, null);
    }

    public static class InputDefinition {
        private String id;
        private String displayName;
        private String description = null;
        private String postfix = null;
        private boolean isMulti = false;
        private int multiCounter;
        private SADLSyntax.InputType type;
        private boolean isOptional;

        public InputDefinition(SADLDescription.Name name, String description, SADLSyntax.InputType type, boolean isOptional) {
            this.resetMulti();
            this.id = name.getID();
            this.displayName = name.getDisplayName();
            this.description = description;
            this.type = type;
            this.isOptional = isOptional;
        }

        public InputDefinition(String prefix, String postfix, String displayName, String description, SADLSyntax.InputType type, boolean isOptional) {
            this.id = prefix;
            this.postfix = postfix;
            this.displayName = displayName;
            this.description = description;
            this.type = type;
            this.isOptional = isOptional;
            this.isMulti = true;
        }

        public String getID() {
            if (!this.isMulti) {
                return this.id;
            }
            return this.id + Strings.toString(this.multiCounter, 3) + this.postfix;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayName(String id) {
            if (!this.isMulti()) {
                return this.displayName;
            }
            if (!this.idMatches(id)) {
                return this.displayName;
            }
            String middle = id.substring(this.id.length(), id.lastIndexOf(this.postfix));
            return this.displayName.replaceAll("\\{\\.\\.\\.\\}", middle);
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public SADLSyntax.InputType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        private void nextMulti() {
            ++this.multiCounter;
        }

        public boolean isMulti() {
            return this.isMulti;
        }

        public void resetMulti() {
            this.multiCounter = 1;
        }

        public boolean idMatches(String id) {
            String middle;
            if (!this.isMulti()) {
                return this.getID().equals(id);
            }
            return id.startsWith(this.id) && id.endsWith(this.postfix) && (middle = id.substring(this.id.length(), id.lastIndexOf(this.postfix))).matches("\\d+");
        }
    }

    public static class BindingResult {
        Suitability suitability;
        LinkedList<Operation.DataBinding> bindings = null;
    }

    public static enum Suitability {
        SUITABLE,
        IMPOSSIBLE,
        EMPTY_REQUIRED_PARAMETERS;


        public boolean isOk() {
            return this == SUITABLE;
        }
    }
}

