/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ImportSession {
    private Source source;
    private List<ImportItem> items;
    private String destinationFolder;
    private boolean useSameDescriptions;
    private boolean skipActionChooser;

    public ImportSession(Source source, Object[] inputs, String destinationFolder, boolean skipActionChooser) {
        this(source, Arrays.asList(inputs), destinationFolder, skipActionChooser);
    }

    public ImportSession(Source source, List<Object> inputs, String destinationFolder, boolean skipActionChooser) {
        this.source = source;
        this.items = this.toImportItems(inputs);
        this.destinationFolder = destinationFolder;
        this.useSameDescriptions = false;
        this.skipActionChooser = skipActionChooser;
    }

    private List<ImportItem> toImportItems(List<Object> inputs) {
        LinkedList<ImportItem> items = new LinkedList<ImportItem>();
        for (Object input : inputs) {
            String name = IOUtils.getFilename(input);
            ContentType type = Session.getSession().getDataManager().guessContentType(name);
            items.add(new ImportItem(input, name, type));
        }
        return items;
    }

    public void makeLocal(Runnable whenReady) throws IOException {
        if (!this.isLocal()) {
            for (ImportItem item : this.items) {
                Object input = item.getInput();
                if (input instanceof File) continue;
                if (input instanceof URL) {
                    URL url = (URL)input;
                    File file = ImportUtils.createTempFile(ImportUtils.URLToFilename(url), ImportUtils.getExtension(ImportUtils.URLToFilename(url)));
                    ImportUtils.getURLFileLoader().loadFileFromURL(url, file, this.destinationFolder, whenReady);
                    item.setInput(file);
                    continue;
                }
                throw new RuntimeException("unknown input type: " + input.getClass().getSimpleName());
            }
            this.source = Source.FILE;
        } else {
            SwingUtilities.invokeLater(whenReady);
        }
    }

    public List<ImportItem> getImportItems() {
        return this.items;
    }

    public Source getSource() {
        return this.source;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setUseSameDescriptions(boolean useSameDescriptions) {
        this.useSameDescriptions = useSameDescriptions;
    }

    public boolean getUseSameDescriptions() {
        return this.useSameDescriptions;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public ImportItem getItemAtIndex(int index) {
        if (index >= this.getItemCount() || index < 0) {
            return null;
        }
        return this.items.get(index);
    }

    public boolean hasCustomFiles() {
        for (ImportItem item : this.items) {
            if (item.getAction() != ImportItem.Action.CUSTOM) continue;
            return true;
        }
        return false;
    }

    public List<ImportItem> getInputFiles() {
        return this.items;
    }

    public List<ImportItem> getCustomFiles() {
        ArrayList<ImportItem> files = new ArrayList<ImportItem>();
        for (ImportItem item : this.items) {
            if (item.getAction() != ImportItem.Action.CUSTOM) continue;
            files.add(item);
        }
        return files;
    }

    public boolean isSkipActionChooser() {
        return this.skipActionChooser;
    }

    public boolean isLocal() {
        return this.source == Source.FILE;
    }

    public static enum Source {
        FILE,
        URL,
        CLIPBOARD;

    }
}

