/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dialog.ClipboardImportDialog;
import fi.csc.microarray.client.dialog.FeedbackDialog;
import fi.csc.microarray.client.selection.DataSelectionManager;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.util.Files;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MicroarrayMenuBar
extends JMenuBar
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MicroarrayMenuBar.class);
    private SwingClientApplication application;
    private JMenu fileMenu = null;
    private JMenu importMenu = null;
    private JMenuItem directImportMenuItem = null;
    private JMenuItem importFromURLMenuItem = null;
    private JMenuItem importFromURLToServerMenuItem = null;
    private JMenuItem importFromClipboardMenuItem = null;
    private JMenuItem openWorkflowsMenuItem = null;
    private JMenuItem openWorkflowsForEachMenuItem = null;
    private JMenu recentWorkflowMenu;
    private JMenu recentWorkflowForEachMenu;
    private JMenuItem addDirMenuItem = null;
    private JMenuItem exportMenuItem = null;
    private JMenuItem quitMenuItem = null;
    private JMenu editMenu = null;
    private JMenuItem renameMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenu viewMenu = null;
    private JMenuItem restoreViewMenuItem = null;
    private JMenu fontSizeMenu = null;
    private JMenu workflowsMenu = null;
    private JMenu helpInfoMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem contentMenuItem;
    private JMenuItem startedMenuItem;
    private JMenuItem sendFeedbackMenuItem;
    private JMenuItem saveWorkflowMenuItem;
    private JMenuItem helpWorkflowMenuItem;
    private JMenuItem archiveSessionMenuItem;
    private JMenuItem saveSessionMenuItem;
    private JMenuItem taskListMenuItem;
    private JMenuItem clearSessionMenuItem;
    private JMenu joinSessionMenu;
    private JMenuItem selectAllMenuItem;
    private JMenuItem historyMenuItem;
    private JMenuItem maximiseVisualisationMenuItem;
    private JMenuItem visualiseMenuItem;
    private JMenuItem closeVisualisationMenuItem;
    private JMenuItem detachMenuItem;
    private JMenu visualisationMenu;
    private JMenu openRepoWorkflowsMenu;
    private boolean hasRepoWorkflows;
    private JMenuItem manageSessionsMenuItem;
    private JMenuItem openExampleSessionMenuItem;

    public MicroarrayMenuBar(SwingClientApplication application) {
        this.application = application;
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getViewMenu());
        this.add(this.getWorkflowsMenu());
        this.add(this.getHelpInfoMenu());
        application.addClientEventListener(this);
    }

    public void updateMenuStatus() {
        logger.debug((Object)("updating menubar when selected is " + this.application.getSelectionManager().getSelectedItem()));
        DataSelectionManager selectionManager = this.application.getSelectionManager();
        DataBean selectedDataBean = selectionManager.getSelectedDataBean();
        boolean somethingSelected = selectionManager.getSelectedItem() != null;
        boolean multipleDatasSelected = selectionManager.getSelectedDataBeans().size() > 1;
        boolean workflowCompatibleDataSelected = false;
        if (selectedDataBean != null) {
            workflowCompatibleDataSelected = Session.getSession().getPrimaryModule().isWorkflowCompatible(selectedDataBean);
        }
        this.renameMenuItem.setEnabled(selectionManager.getSelectedDataBeans().size() == 1);
        this.historyMenuItem.setEnabled(selectedDataBean != null && this.application.getSelectionManager().getSelectedDataBeans().size() == 1);
        this.visualiseMenuItem.setEnabled(selectedDataBean != null);
        VisualisationMethod method = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN).getMethod();
        this.visualisationMenu.setEnabled(method != null);
        this.closeVisualisationMenuItem.setEnabled(!VisualisationMethod.isDefault(method));
        this.openWorkflowsMenuItem.setEnabled(workflowCompatibleDataSelected);
        this.recentWorkflowMenu.setEnabled(workflowCompatibleDataSelected);
        this.openRepoWorkflowsMenu.setEnabled(workflowCompatibleDataSelected && this.hasRepoWorkflows);
        this.openWorkflowsForEachMenuItem.setEnabled(workflowCompatibleDataSelected && multipleDatasSelected);
        this.recentWorkflowForEachMenu.setEnabled(workflowCompatibleDataSelected && multipleDatasSelected);
        this.saveWorkflowMenuItem.setEnabled(workflowCompatibleDataSelected);
        this.exportMenuItem.setEnabled(somethingSelected);
        this.renameMenuItem.setEnabled(somethingSelected);
        this.deleteMenuItem.setEnabled(somethingSelected);
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic('F');
            this.fileMenu.add(this.getDirectImportMenuItem());
            this.fileMenu.add(this.getAddDirMenuItem());
            this.fileMenu.add(this.getImportMenu());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExportMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getLoadLocalSessionMenuItem(true));
            this.fileMenu.add(this.getSaveLocalSessionMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getOpenExampleSessionMenuItem());
            if (this.application.getSessionManager().areCloudSessionsEnabled()) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.getLoadSessionMenuItem(true));
                this.fileMenu.add(this.getSaveSessionMenuItem());
                this.fileMenu.add(this.getManageSessionsMenuItem());
            }
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getMergeSessionMenu());
            this.fileMenu.add(this.getClearSessionMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getQuitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getMergeSessionMenu() {
        if (this.joinSessionMenu == null) {
            this.joinSessionMenu = new JMenu();
            this.joinSessionMenu.setText("Merge session");
            this.joinSessionMenu.add(this.getLoadLocalSessionMenuItem(false));
            if (this.application.getSessionManager().areCloudSessionsEnabled()) {
                this.joinSessionMenu.add(this.getLoadSessionMenuItem(false));
            }
        }
        return this.joinSessionMenu;
    }

    private JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu();
            this.importMenu.setText("Import from");
            if (!this.application.isStandalone()) {
                Module primaryModule = Session.getSession().getPrimaryModule();
                primaryModule.addImportMenuItems(this.importMenu);
            }
            this.importMenu.add(this.getImportFromURLMenuItem());
            this.importMenu.add(this.getImportFromURLToServerMenuItem());
            this.importMenu.add(this.getImportFromClipboardMenuItem());
        }
        return this.importMenu;
    }

    private JMenuItem getDirectImportMenuItem() {
        if (this.directImportMenuItem == null) {
            this.directImportMenuItem = new JMenuItem();
            this.directImportMenuItem.setText("Import files...");
            this.directImportMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.directImportMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openFileImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.directImportMenuItem;
    }

    private JMenuItem getImportFromURLMenuItem() {
        if (this.importFromURLMenuItem == null) {
            this.importFromURLMenuItem = new JMenuItem();
            this.importFromURLMenuItem.setText("URL to client...");
            this.importFromURLMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openURLImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromURLMenuItem;
    }

    private JMenuItem getImportFromURLToServerMenuItem() {
        if (this.importFromURLToServerMenuItem == null) {
            this.importFromURLToServerMenuItem = new JMenuItem();
            this.importFromURLToServerMenuItem.setText("URL directly to server...");
            this.importFromURLToServerMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicModule.importFromUrlToServer();
                }
            });
        }
        return this.importFromURLToServerMenuItem;
    }

    private JMenuItem getHelpWorkflowMenuItem() {
        if (this.helpWorkflowMenuItem == null) {
            this.helpWorkflowMenuItem = new JMenuItem();
            this.helpWorkflowMenuItem.setText("More information...");
            this.helpWorkflowMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.viewHelp("workflows.html#ready");
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.helpWorkflowMenuItem;
    }

    private JMenuItem getOpenWorkflowMenuItem() {
        if (this.openWorkflowsMenuItem == null) {
            this.openWorkflowsMenuItem = new JMenuItem();
            this.openWorkflowsMenuItem.setText("Run...");
            this.openWorkflowsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File workflow = MicroarrayMenuBar.this.application.openWorkflow(false);
                        if (workflow != null) {
                            MicroarrayMenuBar.this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                        }
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.openWorkflowsMenuItem;
    }

    private JMenuItem getOpenWorkflowForEachMenuItem() {
        if (this.openWorkflowsForEachMenuItem == null) {
            this.openWorkflowsForEachMenuItem = new JMenuItem();
            this.openWorkflowsForEachMenuItem.setText("Run for each...");
            this.openWorkflowsForEachMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File workflow = MicroarrayMenuBar.this.application.openWorkflow(true);
                        MicroarrayMenuBar.this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.openWorkflowsForEachMenuItem;
    }

    private JMenu getOpenRepositoryWorkflowMenu() {
        if (this.openRepoWorkflowsMenu == null) {
            String[][] repoWorkflows = Session.getSession().getPrimaryModule().getRepositoryWorkflows();
            this.hasRepoWorkflows = repoWorkflows.length > 0;
            this.openRepoWorkflowsMenu = new JMenu();
            this.openRepoWorkflowsMenu.setText("Run from Chipster repository");
            for (String[] flow : repoWorkflows) {
                JMenuItem item = new JMenuItem(flow[0]);
                item.addActionListener(new RepoWorkflowActionListener(flow[0], flow[1]));
                this.openRepoWorkflowsMenu.add(item);
            }
            this.openRepoWorkflowsMenu.addSeparator();
            this.openRepoWorkflowsMenu.add(this.getHelpWorkflowMenuItem());
        }
        return this.openRepoWorkflowsMenu;
    }

    public void addRecentWorkflow(String name, URL url) {
        if (url != null) {
            for (int i = 0; i < this.recentWorkflowMenu.getItemCount(); ++i) {
                JMenuItem menuItem = this.recentWorkflowMenu.getItem(i);
                if (!menuItem.getText().equals(name)) continue;
                this.recentWorkflowMenu.remove(menuItem);
            }
            this.recentWorkflowMenu.add(this.createRunWorkflowMenuItem(name, url, false));
            this.recentWorkflowForEachMenu.add(this.createRunWorkflowMenuItem(name, url, true));
        }
    }

    private JMenuItem getImportFromClipboardMenuItem() {
        if (this.importFromClipboardMenuItem == null) {
            this.importFromClipboardMenuItem = new JMenuItem();
            this.importFromClipboardMenuItem.setText("Clipboard...");
            this.importFromClipboardMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        new ClipboardImportDialog(Session.getSession().getApplication());
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromClipboardMenuItem;
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem();
            this.exportMenuItem.setText("Export dataset(s) or folder...");
            this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.exportMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.exportSelectedItems();
                }
            });
        }
        return this.exportMenuItem;
    }

    private JMenuItem getQuitMenuItem() {
        if (this.quitMenuItem == null) {
            this.quitMenuItem = new JMenuItem();
            this.quitMenuItem.setText("Quit");
            this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.quitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.quit();
                }
            });
        }
        return this.quitMenuItem;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.setMnemonic('E');
            this.editMenu.add(this.getRenameMenuItem());
            this.editMenu.add(this.getDeleteMenuItem());
            this.editMenu.add(this.getHistoryMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getSelectAllMenuItem());
        }
        return this.editMenu;
    }

    private JMenuItem getHistoryMenuItem() {
        if (this.historyMenuItem == null) {
            this.historyMenuItem = new JMenuItem();
            this.historyMenuItem.setText("Show history...");
            this.historyMenuItem.setIcon(VisualConstants.getIcon(VisualConstants.GENERATE_HISTORY_ICON));
            this.historyMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.historyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataBean data = MicroarrayMenuBar.this.application.getSelectionManager().getSelectedDataBean();
                    if (data != null) {
                        MicroarrayMenuBar.this.application.showHistoryScreenFor(data);
                    }
                }
            });
        }
        return this.historyMenuItem;
    }

    private JMenuItem getRenameMenuItem() {
        if (this.renameMenuItem == null) {
            this.renameMenuItem = new JMenuItem();
            this.renameMenuItem.setText("Rename selected item...");
            this.renameMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
            this.renameMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.showRenameView();
                }
            });
        }
        return this.renameMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText("Delete selected item");
            this.deleteMenuItem.setIcon(VisualConstants.getIcon("/eclipse/delete.gif"));
            this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.deleteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.deleteDatas(MicroarrayMenuBar.this.application.getSelectionManager().getSelectedDataBeans().toArray(new DataItem[0]));
                }
            });
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getSelectAllMenuItem() {
        if (this.selectAllMenuItem == null) {
            this.selectAllMenuItem = new JMenuItem();
            this.selectAllMenuItem.setText("Select all");
            this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.selectAllMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.selectAllItems();
                }
            });
        }
        return this.selectAllMenuItem;
    }

    private JMenu getWorkflowsMenu() {
        if (this.workflowsMenu == null) {
            this.workflowsMenu = new JMenu();
            this.workflowsMenu.setText("Workflow");
            this.workflowsMenu.add(this.getOpenWorkflowMenuItem());
            this.workflowsMenu.add(this.getRecentWorkflowMenu());
            this.workflowsMenu.add(this.getOpenRepositoryWorkflowMenu());
            this.workflowsMenu.addSeparator();
            this.workflowsMenu.add(this.getOpenWorkflowForEachMenuItem());
            this.workflowsMenu.add(this.getRecentWorkflowForEachMenu());
            this.workflowsMenu.addSeparator();
            this.workflowsMenu.add(this.getSaveWorkflowMenuItem());
            if (this.application.isStandalone()) {
                this.workflowsMenu.setEnabled(false);
            } else {
                List<File> workflows = this.application.getWorkflows();
                for (File workflow : workflows) {
                    this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                }
            }
        }
        return this.workflowsMenu;
    }

    private JMenuItem getTaskListMenuItem() {
        if (this.taskListMenuItem == null) {
            this.taskListMenuItem = new JMenuItem();
            this.taskListMenuItem.setText("View jobs...");
            this.taskListMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.taskListMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewTasks();
                }
            });
        }
        return this.taskListMenuItem;
    }

    private JMenuItem getSaveWorkflowMenuItem() {
        if (this.saveWorkflowMenuItem == null) {
            this.saveWorkflowMenuItem = new JMenuItem();
            this.saveWorkflowMenuItem.setText("Save starting from selected...");
            this.saveWorkflowMenuItem.setEnabled(false);
            this.saveWorkflowMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File workflow = MicroarrayMenuBar.this.application.saveWorkflow();
                    if (workflow != null) {
                        MicroarrayMenuBar.this.addRecentWorkflow(workflow.getName(), Files.toUrl(workflow));
                    }
                }
            });
        }
        return this.saveWorkflowMenuItem;
    }

    private JMenu getRecentWorkflowMenu() {
        if (this.recentWorkflowMenu == null) {
            this.recentWorkflowMenu = new JMenu();
            this.recentWorkflowMenu.setText("Run recent");
        }
        return this.recentWorkflowMenu;
    }

    private JMenu getRecentWorkflowForEachMenu() {
        if (this.recentWorkflowForEachMenu == null) {
            this.recentWorkflowForEachMenu = new JMenu();
            this.recentWorkflowForEachMenu.setText("Run recent for each");
        }
        return this.recentWorkflowForEachMenu;
    }

    private JMenuItem createRunWorkflowMenuItem(String name, final URL workflowScript, final boolean runForEach) {
        JMenuItem runWorkflowMenuItem = new JMenuItem(name);
        runWorkflowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroarrayMenuBar.this.application.runWorkflow(workflowScript, runForEach);
            }
        });
        return runWorkflowMenuItem;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.add(this.getRestoreViewMenuItem());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getVisualiseMenutItem());
            this.viewMenu.add(this.getCloseVisualisationMenutItem());
            this.viewMenu.add(this.getVisualisationwMenu());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getFontSize());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getTaskListMenuItem());
        }
        return this.viewMenu;
    }

    private JMenu getVisualisationwMenu() {
        if (this.visualisationMenu == null) {
            this.visualisationMenu = new JMenu();
            this.visualisationMenu.setText("Visualisation");
            this.visualisationMenu.add(this.getMaximiseVisualisationMenuItem());
            this.visualisationMenu.add(this.getDetachMenuItem());
        }
        return this.visualisationMenu;
    }

    private JMenuItem getDetachMenuItem() {
        if (this.detachMenuItem == null) {
            this.detachMenuItem = new JMenuItem();
            this.detachMenuItem.setText("Detach");
            this.detachMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.detachMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VisualisationToolBar visToolBar = MicroarrayMenuBar.this.application.getVisualisationFrameManager().getVisualisationToolBar();
                    visToolBar.detach();
                }
            });
        }
        return this.detachMenuItem;
    }

    private JMenuItem getMaximiseVisualisationMenuItem() {
        if (this.maximiseVisualisationMenuItem == null) {
            this.maximiseVisualisationMenuItem = new JMenuItem();
            this.maximiseVisualisationMenuItem.setText("Maximise/Restore");
            this.maximiseVisualisationMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
            this.maximiseVisualisationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VisualisationToolBar visToolBar = MicroarrayMenuBar.this.application.getVisualisationFrameManager().getVisualisationToolBar();
                    visToolBar.maximiseOrRestoreVisualisation();
                }
            });
        }
        return this.maximiseVisualisationMenuItem;
    }

    private JMenuItem getVisualiseMenutItem() {
        if (this.visualiseMenuItem == null) {
            this.visualiseMenuItem = new JMenuItem();
            this.visualiseMenuItem.setText("Visualise selected");
            this.visualiseMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.visualiseMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.visualiseWithBestMethod(VisualisationFrameManager.FrameType.MAIN);
                }
            });
        }
        return this.visualiseMenuItem;
    }

    private JMenuItem getCloseVisualisationMenutItem() {
        if (this.closeVisualisationMenuItem == null) {
            this.closeVisualisationMenuItem = new JMenuItem();
            this.closeVisualisationMenuItem.setText("Close visualisation");
            this.closeVisualisationMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            this.closeVisualisationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setVisualisationMethodToDefault();
                }
            });
        }
        return this.closeVisualisationMenuItem;
    }

    private JMenuItem getRestoreViewMenuItem() {
        if (this.restoreViewMenuItem == null) {
            this.restoreViewMenuItem = new JMenuItem();
            this.restoreViewMenuItem.setText("Restore default");
            this.restoreViewMenuItem.setIcon(VisualConstants.getIcon("/eclipse/defaultView.gif"));
            this.restoreViewMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.restoreDefaultView();
                }
            });
        }
        return this.restoreViewMenuItem;
    }

    private JMenu getHelpInfoMenu() {
        if (this.helpInfoMenu == null) {
            this.helpInfoMenu = new JMenu();
            this.helpInfoMenu.setText("Help");
            this.helpInfoMenu.setMnemonic('H');
            this.helpInfoMenu.add(this.getStartedMenuItem());
            this.helpInfoMenu.add(this.getContentMenuItem());
            if (DirectoryLayout.getInstance().getConfiguration().getBoolean("client", "enable-contact-support")) {
                this.helpInfoMenu.add(this.getSendFeedbackMenuItem());
            }
            this.helpInfoMenu.add(this.getAboutMenuItem());
        }
        return this.helpInfoMenu;
    }

    private JMenuItem getContentMenuItem() {
        if (this.contentMenuItem == null) {
            this.contentMenuItem = new JMenuItem();
            this.contentMenuItem.setText("User manual");
            this.contentMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            this.contentMenuItem.setIcon(VisualConstants.getIcon("/eclipse/help.gif"));
            this.contentMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp(Session.getSession().getPrimaryModule().getManualHome());
                }
            });
        }
        return this.contentMenuItem;
    }

    private JMenuItem getStartedMenuItem() {
        if (this.startedMenuItem == null) {
            this.startedMenuItem = new JMenuItem();
            this.startedMenuItem.setText("Getting started");
            this.startedMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp(Session.getSession().getPrimaryModule().getManualHome() + "/basic-functionality.html");
                }
            });
        }
        return this.startedMenuItem;
    }

    private JMenuItem getSendFeedbackMenuItem() {
        if (this.sendFeedbackMenuItem == null) {
            this.sendFeedbackMenuItem = new JMenuItem();
            this.sendFeedbackMenuItem.setText("Contact Support...");
            this.sendFeedbackMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackDialog feedback = new FeedbackDialog(MicroarrayMenuBar.this.application, "", false);
                    feedback.showDialog();
                }
            });
        }
        return this.sendFeedbackMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp(Session.getSession().getPrimaryModule().getManualHome() + "/about.html");
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenu getFontSize() {
        if (this.fontSizeMenu == null) {
            this.fontSizeMenu = new JMenu();
            this.fontSizeMenu.setText("Text size");
            JMenuItem norm = new JMenuItem("Normal");
            JMenuItem inc = new JMenuItem("Increase");
            JMenuItem dec = new JMenuItem("Decrease");
            inc.setAccelerator(KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            dec.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            norm.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fontSizeMenu.add(inc);
            this.fontSizeMenu.add(dec);
            this.fontSizeMenu.addSeparator();
            this.fontSizeMenu.add(norm);
            norm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(12.0f);
                }
            });
            dec.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(MicroarrayMenuBar.this.application.getFontSize() - 1.0f);
                }
            });
            inc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.setFontSize(MicroarrayMenuBar.this.application.getFontSize() + 1.0f);
                }
            });
        }
        return this.fontSizeMenu;
    }

    private JMenuItem getOpenExampleSessionMenuItem() {
        if (this.openExampleSessionMenuItem == null) {
            this.openExampleSessionMenuItem = new JMenuItem();
            this.openExampleSessionMenuItem.setText("Open example session");
            this.openExampleSessionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.loadSession(true, true, true);
                }
            });
        }
        return this.openExampleSessionMenuItem;
    }

    private JMenuItem getClearSessionMenuItem() {
        if (this.clearSessionMenuItem == null) {
            this.clearSessionMenuItem = new JMenuItem();
            this.clearSessionMenuItem.setText("New session");
            this.clearSessionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.clearSession();
                    }
                    catch (FileBrokerException | MalformedURLException e1) {
                        MicroarrayMenuBar.this.application.reportException(e1);
                    }
                }
            });
        }
        return this.clearSessionMenuItem;
    }

    private JMenuItem getLoadSessionMenuItem(final boolean clear) {
        JMenuItem loadSessionMenuItem = new JMenuItem();
        if (clear) {
            loadSessionMenuItem.setText("Open cloud session... (BETA)");
        } else {
            loadSessionMenuItem.setText("Cloud session... (BETA)");
        }
        loadSessionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MicroarrayMenuBar.this.application.loadSession(true, false, clear);
                }
                catch (Exception ioe) {
                    MicroarrayMenuBar.this.application.reportException(ioe);
                }
            }
        });
        return loadSessionMenuItem;
    }

    private JMenuItem getLoadLocalSessionMenuItem(final boolean clear) {
        JMenuItem loadLocalSessionMenuItem = new JMenuItem();
        loadLocalSessionMenuItem.setText("Open local session...");
        if (clear) {
            loadLocalSessionMenuItem.setText("Open local session...");
            loadLocalSessionMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        } else {
            loadLocalSessionMenuItem.setText("Local session...");
        }
        loadLocalSessionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MicroarrayMenuBar.this.application.loadSession(false, false, clear);
                }
                catch (Exception ioe) {
                    MicroarrayMenuBar.this.application.reportException(ioe);
                }
            }
        });
        return loadLocalSessionMenuItem;
    }

    private JMenuItem getSaveSessionMenuItem() {
        if (this.saveSessionMenuItem == null) {
            this.saveSessionMenuItem = new JMenuItem();
            this.saveSessionMenuItem.setText("Save cloud session... (BETA)");
            this.saveSessionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.saveSession(SwingClientApplication.SessionSavingMethod.UPLOAD_DATA_TO_SERVER);
                }
            });
        }
        return this.saveSessionMenuItem;
    }

    private JMenuItem getManageSessionsMenuItem() {
        if (this.manageSessionsMenuItem == null) {
            this.manageSessionsMenuItem = new JMenuItem();
            this.manageSessionsMenuItem.setText("Manage cloud sessions... (BETA)");
            this.manageSessionsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.manageRemoteSessions();
                }
            });
        }
        return this.manageSessionsMenuItem;
    }

    private JMenuItem getSaveLocalSessionMenuItem() {
        if (this.archiveSessionMenuItem == null) {
            this.archiveSessionMenuItem = new JMenuItem();
            this.archiveSessionMenuItem.setText("Save local session...");
            this.archiveSessionMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.archiveSessionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.saveSession(SwingClientApplication.SessionSavingMethod.INCLUDE_DATA_INTO_ZIP);
                }
            });
        }
        return this.archiveSessionMenuItem;
    }

    private JMenuItem getAddDirMenuItem() {
        if (this.addDirMenuItem == null) {
            this.addDirMenuItem = new JMenuItem();
            this.addDirMenuItem.setText("Import folder...");
            this.addDirMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40, false));
            this.addDirMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.openDirectoryImportDialog();
                }
            });
        }
        return this.addDirMenuItem;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof DatasetChoiceEvent || evt instanceof VisualisationMethodChangedEvent) {
            this.updateMenuStatus();
        }
    }

    private class RepoWorkflowActionListener
    implements ActionListener {
        private String resourceName;
        private String name;

        public RepoWorkflowActionListener(String name, String resourceName) {
            this.name = name;
            this.resourceName = resourceName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URL url = this.getClass().getResource(this.resourceName);
            MicroarrayMenuBar.this.application.runWorkflow(url, false);
            MicroarrayMenuBar.this.addRecentWorkflow(this.name, url);
        }
    }
}

