/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.AtEndListener;
import fi.csc.microarray.client.Authenticator;
import fi.csc.microarray.client.ClientConstants;
import fi.csc.microarray.client.HelpMapping;
import fi.csc.microarray.client.LocalServiceAccessor;
import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.selection.DataSelectionManager;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.workflow.WorkflowManager;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.HistoryText;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.messaging.SourceMessageListener;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.auth.ClientLoginListener;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.SwingTools;
import fi.csc.microarray.util.ThreadUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.swing.Icon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.IO;

public abstract class ClientApplication {
    protected static final int MEMORY_CHECK_INTERVAL = 2000;
    protected static Logger logger;
    protected String metadata;
    protected CountDownLatch definitionsInitialisedLatch = new CountDownLatch(1);
    private boolean eventsEnabled = false;
    private PropertyChangeSupport eventSupport = new PropertyChangeSupport(this);
    protected String requestedModule;
    protected LinkedList<ToolModule> toolModules = new LinkedList();
    protected WorkflowManager workflowManager;
    protected DataManager manager;
    protected DataSelectionManager selectionManager;
    protected ServiceAccessor serviceAccessor;
    protected TaskExecutor taskExecutor;
    protected ExecutorService backgroundExecutor = Executors.newCachedThreadPool();
    private AuthenticationRequestListener overridingARL;
    protected ClientConstants clientConstants;
    protected Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
    private String initialisationWarnings = "";
    private String announcementText = null;
    private SessionManager sessionManager;

    public abstract void initialiseGUIThreadSafely(File var1) throws MicroarrayException, IOException;

    public abstract void reportInitialisationThreadSafely(String var1, boolean var2);

    public abstract void reportExceptionThreadSafely(Exception var1);

    public abstract void reportException(Exception var1);

    public abstract void reportTaskError(Task var1) throws MicroarrayException;

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6, ChipsterDialog.PluginButton var7);

    public abstract void showDialog(String var1, String var2, String var3, DialogInfo.Severity var4, boolean var5, ChipsterDialog.DetailsVisibility var6, ChipsterDialog.PluginButton var7, boolean var8);

    public abstract void runBlockingTask(String var1, Runnable var2);

    public VisualisationMethod getDefaultVisualisationForSelection() {
        logger.debug((Object)"getting default visualisation");
        try {
            List<DataBean> beans = this.getSelectionManager().getSelectedDataBeans();
            if (beans.size() == 1) {
                return Session.getSession().getVisualisations().getDefaultVisualisationFor(beans.get(0));
            }
            if (beans.size() > 1) {
                for (VisualisationMethod method : Session.getSession().getVisualisations().getOrderedDefaultCandidates()) {
                    if (!method.getHeadlessVisualiser().isForMultipleDatas() || !method.isApplicableTo(beans)) continue;
                    return method;
                }
            }
            return null;
        }
        catch (Exception e) {
            this.reportException(e);
            return null;
        }
    }

    public ClientApplication() {
        this(null);
    }

    public ClientApplication(AuthenticationRequestListener overridingARL) {
        this.clientConstants = new ClientConstants();
        this.serviceAccessor = new RemoteServiceAccessor();
        this.overridingARL = overridingARL;
    }

    public void initialiseApplication(boolean fast) throws MicroarrayException, IOException {
        logger = Logger.getLogger(ClientApplication.class);
        try {
            this.fetchAnnouncements();
            if (this.requestedModule == null) {
                this.requestedModule = MicroarrayModule.class.getName();
            }
            ModuleManager modules = new ModuleManager(this.requestedModule);
            Session.getSession().setModuleManager(modules);
            this.workflowManager = new WorkflowManager(this);
            this.manager = new DataManager();
            Session.getSession().setDataManager(this.manager);
            modules.plugAll(this.manager, Session.getSession());
            this.selectionManager = new DataSelectionManager(this);
            Session.getSession().setClientApplication(this);
            logger.debug((Object)"Initialise JMS connection.");
            Session.getSession().setServiceAccessor(this.serviceAccessor);
            this.reportInitialisationThreadSafely("Connecting to broker at " + this.configuration.getString("messaging", "broker-host") + "...", false);
            try {
                this.serviceAccessor.initialise(this.manager, this.getAuthenticationRequestListener());
            }
            catch (Exception e) {
                this.serviceAccessor.close();
                throw e;
            }
            this.taskExecutor = this.serviceAccessor.getTaskExecutor();
            this.sessionManager = new SessionManager(this.manager, this.taskExecutor, this.serviceAccessor.getFileBrokerClient(), new ClientSessionManagerCallback(this));
            this.reportInitialisationThreadSafely(" ok", true);
            if (!fast) {
                this.reportInitialisationThreadSafely("Checking remote services...", false);
                String status = this.serviceAccessor.checkRemoteServices();
                if (!"ok".equals(status)) {
                    throw new Exception(status);
                }
                this.reportInitialisationThreadSafely(" ok", true);
            }
            this.reportInitialisationThreadSafely("Fetching analysis descriptions...", false);
            this.initialisationWarnings = this.initialisationWarnings + this.serviceAccessor.fetchDescriptions(modules.getPrimaryModule());
            this.toolModules.addAll(this.serviceAccessor.getModules());
            if (!this.isStandalone()) {
                LocalServiceAccessor localServiceAccessor = new LocalServiceAccessor();
                localServiceAccessor.initialise(this.manager, null);
                localServiceAccessor.fetchDescriptions(modules.getPrimaryModule());
                this.toolModules.addAll(localServiceAccessor.getModules());
            }
            ToolCategory internalCategory = new ToolCategory("Internal tools");
            internalCategory.addOperation(OperationDefinition.IMPORT_DEFINITION);
            internalCategory.addOperation(OperationDefinition.CREATE_DEFINITION);
            ToolModule internalModule = new ToolModule("internal");
            internalModule.addHiddenToolCategory(internalCategory);
            this.toolModules.add(internalModule);
            this.reportInitialisationThreadSafely(" ok", true);
            this.definitionsInitialisedLatch.countDown();
            File mostRecentDeadTempDirectory = null;
            if (!fast) {
                this.reportInitialisationThreadSafely("Checking session backups...", false);
                mostRecentDeadTempDirectory = this.sessionManager.checkTempDirectories();
                this.reportInitialisationThreadSafely(" ok", true);
            }
            this.initialiseGUIThreadSafely(mostRecentDeadTempDirectory);
            fi.csc.microarray.util.IOUtils.disableHttpCache();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MicroarrayException("Startup failed\nDebug info:\n" + this.getConnectionDebugInfo(), e);
        }
    }

    private String getConnectionDebugInfo() {
        String msg = "";
        msg = msg + "\nSystem properties\n";
        for (Object key : System.getProperties().keySet()) {
            msg = msg + key + ": \t" + System.getProperty(key.toString()) + "\n";
        }
        try {
            SSLParameters sslParams = SSLContext.getDefault().getSupportedSSLParameters();
            msg = msg + "\nProtocols\n";
            for (String protocol : sslParams.getProtocols()) {
                msg = msg + protocol + "\n";
            }
            msg = msg + "\nCipher suites\n";
            for (String cipher : sslParams.getCipherSuites()) {
                msg = msg + cipher + "\n";
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"failed to get ssl debug info", (Throwable)e);
            msg = msg + "failed to get ssl debug info\n";
        }
        return msg;
    }

    public DataFolder initializeFolderForImport(String folderName) {
        return this.manager.getRootFolder();
    }

    public void addClientEventListener(PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(listener);
    }

    public void removeClientEventListener(PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(listener);
    }

    public DataSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void selectAllItems() {
        List<DataBean> datas = this.manager.databeans();
        for (DataBean data : datas) {
            this.selectionManager.selectMultiple(data, (Object)this);
        }
    }

    public void setVisualisationMethod(VisualisationMethod method, List<Visualisation.Variable> variables, List<DataBean> datas, VisualisationFrameManager.FrameType target) {
        this.fireClientEvent(new VisualisationMethodChangedEvent(this, method, variables, datas, target));
    }

    public void setVisualisationMethod(VisualisationMethodChangedEvent e) {
        this.fireClientEvent(e);
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
        this.taskExecutor.setEventsEnabled(eventsEnabled);
    }

    public void renameDataItem(DataItem data, String newName) {
        data.setName(newName);
    }

    public Task executeOperation(final Operation operation) {
        if (!operation.getDefinition().isLocal() && Session.getSession().getUsername() != null && Session.getSession().getUsername().equals(this.configuration.getString("security", "guest-username"))) {
            this.showDialog("Running tools is disabled for guest users.", "", null, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, null);
            return null;
        }
        if (this.taskExecutor.getRunningTaskCount() >= this.clientConstants.MAX_JOBS) {
            this.showDialog("Task not started as there are maximum number of tasks already running.", "You can only run " + this.clientConstants.MAX_JOBS + " tasks at the same time. Please wait for one of the currently running tasks to finish and try again.", null, DialogInfo.Severity.INFO, false);
            return null;
        }
        this.sessionManager.setUnsavedChanges();
        OperationRecord operationRecord = new OperationRecord(operation);
        Task task = this.taskExecutor.createNewTask(operationRecord, operation.getDefinition().isLocal());
        task.addTaskEventListener(new TaskEventListener(){

            @Override
            public void onStateChange(Task job, Task.State oldState, Task.State newState) {
                if (newState.isFinished()) {
                    try {
                        ClientApplication.this.onFinishedTask(job, operation.getResultListener(), newState, false);
                    }
                    catch (Exception e) {
                        ClientApplication.this.reportException(e);
                    }
                }
            }
        });
        try {
            this.onNewTask(task, operation);
            this.taskExecutor.startExecuting(task);
        }
        catch (TaskException | MicroarrayException | IOException te) {
            this.reportException(te);
        }
        return task;
    }

    public Task continueOperation(OperationRecord operationRecord) {
        boolean local = false;
        Task task = this.taskExecutor.createContinuedTask(operationRecord, local);
        task.addTaskEventListener(new TaskEventListener(){

            @Override
            public void onStateChange(Task job, Task.State oldState, Task.State newState) {
                if (newState.isFinished()) {
                    try {
                        ClientApplication.this.onFinishedTask(job, null, newState, false);
                    }
                    catch (Exception e) {
                        ClientApplication.this.reportException(e);
                    }
                }
            }
        });
        try {
            this.taskExecutor.continueExecuting(task);
        }
        catch (TaskException te) {
            this.reportException(te);
        }
        return task;
    }

    public void onNewTask(Task task, Operation oper) throws MicroarrayException, IOException {
        Module primaryModule = Session.getSession().getPrimaryModule();
        for (DataBean input : task.getInputDataBeans()) {
            if (!primaryModule.isMetadata(input)) continue;
            primaryModule.preProcessInputMetadata(oper, input);
        }
    }

    public void onFinishedTask(final Task task, final Operation.ResultListener resultListener, Task.State state, boolean wait) throws MicroarrayException, IOException {
        logger.debug((Object)("operation finished, state is " + (Object)((Object)state)));
        if (state == Task.State.CANCELLED) {
            if (resultListener != null) {
                resultListener.noResults();
            }
        } else if (!state.finishedSuccesfully()) {
            this.reportTaskError(task);
            if (resultListener != null) {
                resultListener.noResults();
            }
        } else {
            Module primaryModule = Session.getSession().getPrimaryModule();
            final LinkedList<DataBean> sources = new LinkedList<DataBean>();
            for (DataBean dataBean : task.getInputDataBeans()) {
                if (primaryModule.isMetadata(dataBean) || dataBean.getParent() == null) continue;
                sources.add(dataBean);
            }
            final DataFolder folder = this.manager.getRootFolder();
            for (DataBean output : task.getOutputs()) {
                output.setOperationRecord(task.getOperationRecord());
                for (DataBean dataBean : sources) {
                    output.addLink(DataBean.Link.DERIVATION, dataBean);
                }
            }
            Future<?> future = this.backgroundExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClientApplication.this.createOutputs(task, sources, folder, resultListener);
                }
            });
            if (wait) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new MicroarrayException("error when creating outputs", e);
                }
            }
        }
    }

    private void createOutputs(final Task task, LinkedList<DataBean> sources, DataFolder folder, final Operation.ResultListener resultListener) {
        this.manager.connectChildren(task.getOutputs(), folder);
        ThreadUtils.runInEDT(new Runnable(){

            @Override
            public void run() {
                Module primaryModule = Session.getSession().getPrimaryModule();
                LinkedList<DataBean> newBeans = new LinkedList<DataBean>();
                DataBean metadataOutput = null;
                for (DataBean output : task.getOutputs()) {
                    if (primaryModule.isMetadata(output)) {
                        metadataOutput = output;
                    }
                    newBeans.add(output);
                }
                if (metadataOutput != null) {
                    for (DataBean bean : newBeans) {
                        if (bean == metadataOutput) continue;
                        metadataOutput.addLink(DataBean.Link.ANNOTATION, bean);
                    }
                    try {
                        primaryModule.postProcessOutputMetadata(task.getOperationRecord(), metadataOutput);
                    }
                    catch (MicroarrayException | IOException e) {
                        ClientApplication.this.reportException(e);
                    }
                }
                if (resultListener != null && task.getState().finishedSuccesfully()) {
                    resultListener.resultData(newBeans);
                }
            }
        });
    }

    public void quit() {
        logger.debug((Object)"quitting client");
        try {
            this.serviceAccessor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireClientEvent(PropertyChangeEvent event) {
        logger.debug((Object)("dispatching event: " + event));
        if (this.eventsEnabled) {
            this.eventSupport.firePropertyChange(event);
        }
    }

    public void fetchSourceFor(String[] operationIDs, SourceCodeListener listener) throws MicroarrayException {
        int i = -1;
        for (String id : operationIDs) {
            ++i;
            logger.debug((Object)("describe operation " + id));
            if (id == null) {
                listener.updateSourceCodeAt(i, null);
                continue;
            }
            SourceMessageListener sourceListener = null;
            try {
                sourceListener = this.serviceAccessor.retrieveSourceCode(id);
                String source = sourceListener.waitForResponse(60L, TimeUnit.SECONDS);
                listener.updateSourceCodeAt(i, source);
            }
            catch (Exception e) {
                throw new MicroarrayException(e);
            }
            finally {
                if (sourceListener != null) {
                    sourceListener.cleanUp();
                }
            }
        }
    }

    public void importWholeDirectory(File root) {
        LinkedList<Object> onlyFiles = new LinkedList<Object>();
        for (File file : root.listFiles()) {
            if (!file.isFile()) continue;
            onlyFiles.add(file);
        }
        ImportSession importSession = new ImportSession(ImportSession.Source.FILE, onlyFiles, root.getName(), true);
        ImportUtils.executeImport(importSession);
    }

    public OperationDefinition getOperationDefinition(String toolId) {
        for (ToolModule module : this.toolModules) {
            OperationDefinition tool = module.getOperationDefinition(toolId);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public OperationDefinition getOperationDefinitionBestMatch(String toolId, String moduleName, String categoryName) {
        ToolModule preferredModule = this.getModule(moduleName);
        if (preferredModule != null) {
            OperationDefinition preferredTool = preferredModule.getOperationDefinition(toolId, categoryName);
            if (preferredTool != null) {
                return preferredTool;
            }
            preferredTool = preferredModule.getOperationDefinition(toolId);
            if (preferredTool != null) {
                return preferredTool;
            }
        } else {
            OperationDefinition toolWithCategoryMismatch = null;
            for (ToolModule module : this.toolModules) {
                OperationDefinition tool = module.getOperationDefinition(toolId, categoryName);
                if (tool != null) {
                    return tool;
                }
                tool = module.getOperationDefinition(toolId);
                if (tool == null) continue;
                toolWithCategoryMismatch = tool;
            }
            return toolWithCategoryMismatch;
        }
        return null;
    }

    public void exportToFileAndWait(DataBean data, File selectedFile) {
        try {
            File newFile = selectedFile;
            int i = 1;
            while (newFile.exists()) {
                String[] parts = Files.parseFilename(selectedFile);
                newFile = new File(parts[0] + File.separator + parts[1] + "_" + ++i + "." + parts[2]);
            }
            newFile.createNewFile();
            try (ChecksumInputStream in = Session.getSession().getDataManager().getContentStream(data, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);){
                try (FileOutputStream out = new FileOutputStream(newFile);){
                    IO.copy((InputStream)in, (OutputStream)out);
                }
                this.manager.setOrVerifyChecksum(data, in.verifyChecksums());
            }
        }
        catch (ChecksumException e) {
            this.reportExceptionThreadSafely(new ChecksumException("checksum validation of the exported file failed", e));
        }
        catch (Exception e) {
            this.reportExceptionThreadSafely(e);
        }
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    protected AuthenticationRequestListener getAuthenticationRequestListener() {
        AuthenticationRequestListener authenticator = this.overridingARL != null ? this.overridingARL : new Authenticator();
        authenticator.setLoginListener(new ClientLoginListener(){

            @Override
            public void firstLogin() {
            }

            @Override
            public void loginCancelled() {
                System.exit(1);
            }
        });
        return authenticator;
    }

    public boolean isStandalone() {
        return false;
    }

    private ToolModule getModule(String moduleName) {
        for (ToolModule toolModule : this.toolModules) {
            if (!toolModule.getModuleName().equals(moduleName)) continue;
            return toolModule;
        }
        return null;
    }

    public String getInitialisationWarnings() {
        return this.initialisationWarnings;
    }

    private void fetchAnnouncements() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream input = null;
                try {
                    URL url = new URL("http://chipster.csc.fi/announcements/client.txt");
                    URLConnection connection = url.openConnection();
                    connection.setUseCaches(false);
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    input = connection.getInputStream();
                    ClientApplication.this.announcementText = IOUtils.toString((InputStream)input);
                }
                catch (Exception exception) {
                    IOUtils.closeQuietly(input);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
        }).start();
    }

    public String getAnnouncementText() {
        return this.announcementText;
    }

    public DataManager getDataManager() {
        return this.manager;
    }

    public LinkedList<ToolModule> getToolModules() {
        return this.toolModules;
    }

    public void importGroupAndWait(Collection<ImportItem> datas, String folderName) {
        DataBean lastGroupMember = null;
        try {
            for (ImportItem item : datas) {
                DataBean data;
                String dataSetName = item.getInputFilename();
                ContentType contentType = item.getType();
                Object dataSource = item.getInput();
                DataFolder folder = this.initializeFolderForImport(folderName);
                if (dataSource instanceof File) {
                    data = this.manager.createDataBean(dataSetName, (File)dataSource);
                } else if (dataSource instanceof URL) {
                    data = this.manager.createDataBean(dataSetName, (URL)dataSource);
                } else {
                    throw new RuntimeException("unknown data source type: " + dataSource.getClass().getSimpleName());
                }
                data.setContentType(contentType);
                Operation importOperation = new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{data});
                data.setOperationRecord(new OperationRecord(importOperation));
                this.manager.connectChild(data, folder);
                if (lastGroupMember != null && ChipsterInputTypes.hasRawType(lastGroupMember) && ChipsterInputTypes.hasRawType(data)) {
                    DataBean targetData = data;
                    for (DataBean sourceData : lastGroupMember.traverseLinks(new DataBean.Link[]{DataBean.Link.GROUPING}, DataBean.Traversal.BIDIRECTIONAL)) {
                        logger.debug((Object)("Created GROUPING link between " + sourceData.getName() + " and " + targetData.getName()));
                        this.createLink(sourceData, targetData, DataBean.Link.GROUPING);
                    }
                    this.createLink(lastGroupMember, targetData, DataBean.Link.GROUPING);
                }
                lastGroupMember = data;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getHelpUrl(String page) {
        if (!page.startsWith(HelpMapping.MANUAL_ROOT)) {
            return HelpMapping.MANUAL_ROOT + page;
        }
        return page;
    }

    public String getHelpFor(OperationDefinition definition) {
        String url = definition.getHelpURL();
        url = url != null && !url.isEmpty() ? definition.getHelpURL() : HelpMapping.mapToHelppage(definition);
        return url;
    }

    public String getHistoryText(DataBean data, boolean title, boolean name, boolean date, boolean versions, boolean oper, boolean code, boolean notes, boolean param) {
        return new HistoryText(data).getHistoryText(title, name, date, versions, oper, code, notes, param);
    }

    public Icon getIconFor(DataItem element) {
        if (element instanceof DataFolder) {
            return VisualConstants.getIcon("/types/folder.gif");
        }
        return Session.getSession().getPrimaryModule().getIconFor((DataBean)element);
    }

    public void deleteDatasWithoutConfirming(DataItem ... datas) {
        if (datas.length == 0) {
            return;
        }
        this.getSelectionManager().clearAll(true, this);
        for (DataItem data : datas) {
            this.manager.delete(data);
        }
    }

    public void createLink(DataBean source, DataBean target, DataBean.Link type) {
        source.addLink(type, target);
    }

    public void removeLink(DataBean source, DataBean target, DataBean.Link type) {
        source.removeLink(type, target);
    }

    public List<File> getWorkflows() {
        return this.workflowManager.getWorkflows();
    }

    public void saveWorkflow(File file) throws IOException {
        this.workflowManager.saveSelectedWorkflow(file);
    }

    public void runWorkflowAndWait(URL workflowScript) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.workflowManager.runScript(workflowScript, new AtEndListener(){

            @Override
            public void atEnd(boolean success) {
                latch.countDown();
            }
        });
        latch.await();
    }

    public void runWorkflow(URL workflowScript, boolean runForEach) {
        if (!runForEach) {
            this.workflowManager.runScript(workflowScript, null);
        } else {
            List<DataBean> datas = this.getSelectionManager().getSelectedDataBeans();
            for (DataBean data : datas) {
                final CountDownLatch latch = new CountDownLatch(1);
                AtEndListener atEndListener = new AtEndListener(){

                    @Override
                    public void atEnd(boolean success) {
                        logger.debug((Object)"workflow run for each: at end");
                        latch.countDown();
                    }
                };
                this.getSelectionManager().selectSingle(data, this);
                logger.debug((Object)("workflow run for each: selected " + this.getSelectionManager().getSelectedDataBeans().size()));
                this.workflowManager.runScript(workflowScript, atEndListener);
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug((Object)"workflow run for each: restore original selection");
            LinkedList<DataItem> items = new LinkedList<DataItem>();
            items.addAll(datas);
            this.getSelectionManager().selectMultiple(items, (Object)this);
        }
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void fireClientEventThreadSafely(final PropertyChangeEvent event) {
        SwingTools.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ClientApplication.this.fireClientEvent(event);
            }
        });
    }

    public static interface SourceCodeListener {
        public void updateSourceCodeAt(int var1, String var2);
    }

    public class ClientSessionManagerCallback
    implements SessionManager.SessionManagerCallback {
        private ClientApplication app;

        public ClientSessionManagerCallback(ClientApplication app) {
            this.app = app;
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility) {
            this.app.showDialog(title, message, details, severity, modal, detailsVisibility, null);
        }

        @Override
        public void reportException(Exception e) {
            this.app.reportException(e);
        }

        @Override
        public void sessionChanged(SessionManager.SessionChangedEvent e) {
            this.app.fireClientEventThreadSafely(e);
        }

        @Override
        public List<OperationRecord> getUnfinishedJobs() {
            ArrayList<OperationRecord> unfinishedJobs = new ArrayList<OperationRecord>();
            for (Task task : Session.getSession().getApplication().getTaskExecutor().getTasks(true, true)) {
                unfinishedJobs.add(task.getOperationRecord());
            }
            return unfinishedJobs;
        }

        @Override
        public void continueJobs(List<OperationRecord> unifinishedJobs) {
            if (unifinishedJobs != null) {
                for (OperationRecord job : unifinishedJobs) {
                    ClientApplication.this.continueOperation(job);
                }
            }
        }
    }
}

