/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.auth.AuthorisationException;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.security.SecureSessionPool;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.util.Arrays;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class Authenticator
extends NodeBase
implements ShutdownCallback {
    private static Logger logger = null;
    private static Logger securityLogger = null;
    private static Logger messageLogger = null;
    private SecureSessionPool sessionPool;
    private MessagingEndpoint endpoint;
    private MessagingTopic authorisedTopic;
    private MessagingTopic authorisedFilebrokerTopic;
    private MessagingTopic authorisedFeedbackTopic;
    private MessagingTopic testTopic;
    private TestListener testListener;
    private AuthenticationProvider authenticationProvider;

    public Authenticator(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("auth"), configURL);
        logger = Logger.getLogger(Authenticator.class);
        securityLogger = Logger.getLogger((String)"security.frontend");
        messageLogger = Logger.getLogger((String)"messages.frontend");
        this.sessionPool = new SecureSessionPool();
        this.endpoint = new JMSMessagingEndpoint(this);
        this.authorisedTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.authorisedFilebrokerTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.authorisedFeedbackTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FEEDBACK_TOPIC, MessagingTopic.AccessMode.WRITE);
        RequestListener jobListener = new RequestListener(this.authorisedTopic);
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        requestTopic.setListener(jobListener);
        RequestListener filebrokerListener = new RequestListener(this.authorisedFilebrokerTopic);
        MessagingTopic filebrokerTopic = this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.READ);
        filebrokerTopic.setListener(filebrokerListener);
        RequestListener feedbackListener = new RequestListener(this.authorisedFeedbackTopic);
        MessagingTopic feedbackTopic = this.endpoint.createTopic(Topics.Name.FEEDBACK_TOPIC, MessagingTopic.AccessMode.READ);
        feedbackTopic.setListener(feedbackListener);
        this.testTopic = this.endpoint.createTopic(Topics.Name.TEST_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
        this.testListener = new TestListener();
        this.testTopic.setListener(this.testListener);
        this.authenticationProvider = new JaasAuthenticationProvider();
        KeepAliveShutdownHandler.init(this);
        logger.info((Object)("authenticator is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
    }

    @Override
    public String getName() {
        return "authenticator";
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private class TestListener
    implements MessagingListener {
        private TestListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            logger.debug((Object)"got message on test-topic.");
            try {
                Destination dest = msg.getReplyTo();
                if (dest != null) {
                    CommandMessage replyMessage = new CommandMessage("OK");
                    Authenticator.this.endpoint.replyToMessage(msg, replyMessage);
                } else {
                    logger.debug((Object)"ReplyTo is null, so no reply was sent.");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private class RequestListener
    implements MessagingListener {
        private static final String KEY_PENDING_MESSAGE = "pending-message";
        private static final String KEY_USERNAME = "username";
        private MessagingTopic routeTo;

        public RequestListener(MessagingTopic routeTo) {
            this.routeTo = routeTo;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            try {
                logger.debug((Object)("starting to process " + msg));
                ChipsterMessage messageToBeRouted = null;
                SecureSessionPool.Session session = null;
                if (msg.getSessionID() != null) {
                    String id = msg.getSessionID();
                    if (Authenticator.this.sessionPool.getSession(id) != null) {
                        session = Authenticator.this.sessionPool.getSession(id);
                        logger.debug((Object)("message " + msg.getMessageID() + " had a proper session " + session.getID()));
                    }
                }
                if (session == null) {
                    logger.debug((Object)("message " + msg + " has no session, requires authentication"));
                    session = Authenticator.this.sessionPool.createSession();
                    logger.debug((Object)("created new session, pool size is now " + Authenticator.this.sessionPool.size()));
                    session.putParameter(KEY_PENDING_MESSAGE, msg);
                    this.requestAuthentication(msg, session.getID().toString());
                } else {
                    if (msg instanceof AuthenticationMessage) {
                        AuthenticationMessage authMsg = (AuthenticationMessage)msg;
                        if (!authMsg.isLogin()) {
                            if (!authMsg.isLogout()) throw new IllegalArgumentException("unknown authentication message: " + authMsg);
                            logger.debug((Object)("message " + msg.getMessageID() + " is a logout"));
                            Authenticator.this.sessionPool.removeSession(session);
                            return;
                        }
                        messageLogger.debug((Object)("message " + authMsg.getMessageID() + " is a login"));
                        if (!Authenticator.this.authenticationProvider.authenticate(authMsg.getUsername(), authMsg.getPassword().toCharArray())) {
                            securityLogger.info((Object)("illegal username/password (user " + authMsg.getUsername() + ", auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                            this.ackLogin(authMsg, session.getID().toString(), false);
                            return;
                        }
                        try {
                            this.ackLogin(authMsg, session.getID().toString(), true);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("could not send acknowledge message for " + authMsg.getUsername()));
                        }
                        session.putParameter(KEY_USERNAME, authMsg.getUsername());
                        authMsg.setSessionID(session.getID().toString());
                        securityLogger.info((Object)("authenticated user " + authMsg.getUsername() + " (auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                        if (session.getParameter(KEY_PENDING_MESSAGE) != null) {
                            messageToBeRouted = (ChipsterMessage)session.getParameter(KEY_PENDING_MESSAGE);
                        }
                    } else {
                        messageToBeRouted = msg;
                    }
                    session.touch();
                }
                if (messageToBeRouted == null) return;
                String username = (String)session.getParameter(KEY_USERNAME);
                if (username != null && !username.equals("")) {
                    messageLogger.info((Object)messageToBeRouted);
                    messageToBeRouted.setUsername(username);
                    this.routeTo.sendMessage(messageToBeRouted);
                    return;
                }
                logger.warn((Object)"not routing a message with null or empty username");
                SecureSessionPool.Session sessionToBeRemoved = Authenticator.this.sessionPool.getSession(messageToBeRouted.getSessionID());
                if (sessionToBeRemoved == null) return;
                Authenticator.this.sessionPool.removeSession(sessionToBeRemoved);
                return;
            }
            catch (JMSException e) {
                logger.error((Object)e);
                return;
            }
            catch (AuthorisationException e) {
                securityLogger.info((Object)("authorisation failed: " + e.getMessage()));
                logger.info((Object)e);
            }
        }

        private void ackLogin(ChipsterMessage loginMessage, String sessionID, boolean succeeded) throws JMSException, AuthorisationException {
            AuthenticationMessage.AuthenticationOperation operation = succeeded ? AuthenticationMessage.AuthenticationOperation.LOGIN_SUCCEEDED : AuthenticationMessage.AuthenticationOperation.LOGIN_FAILED;
            AuthenticationMessage request = new AuthenticationMessage(operation);
            request.setSessionID(sessionID);
            request.setReplyTo(loginMessage.getReplyTo());
            if (succeeded) {
                request.setUsername(loginMessage.getUsername());
            }
            Authenticator.this.endpoint.replyToMessage(loginMessage, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }

        private void requestAuthentication(ChipsterMessage msg, String sessionID) throws JMSException, AuthorisationException {
            AuthenticationMessage request = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.REQUEST);
            request.setSessionID(sessionID);
            request.setReplyTo(msg.getReplyTo());
            logger.debug((Object)("requesting authentication for " + msg.getMessageID() + " under the session " + sessionID));
            Authenticator.this.endpoint.replyToMessage(msg, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }
    }
}

