/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs.regions;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.RegionOperations;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;

public abstract class RegionTool
extends JavaCompJobBase {
    protected abstract LinkedList<Feature> operate(LinkedList<List<Feature>> var1, List<String> var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        try {
            this.updateStateToClient(JobState.RUNNING, "preprocessing");
            RegionOperations tool = new RegionOperations();
            LinkedList<List<Feature>> inputs = new LinkedList<List<Feature>>();
            for (int i = 0; i < this.toolDescription.getInputFiles().size(); ++i) {
                File inputFile = new File(this.jobWorkDir, this.toolDescription.getInputFiles().get(i).getFileName());
                inputs.add(tool.loadFile(inputFile));
            }
            List<String> parameters = this.inputMessage.getParameters(JAVA_PARAMETER_SECURITY_POLICY, this.toolDescription);
            LinkedList<Feature> output = this.operate(inputs, parameters);
            new RegionOperations().sort(output);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(new File(this.jobWorkDir, this.toolDescription.getOutputFiles().get(0).getFileName().getID()));
                tool.print(output, outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeIfPossible(outputStream);
                throw throwable;
            }
            IOUtils.closeIfPossible(outputStream);
        }
        catch (Exception e) {
            this.updateState(JobState.FAILED, e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "preprocessing finished");
    }
}

