/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.VcfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import java.io.File;

public class SortVcf
extends JavaCompJobBase {
    @Override
    public String getSADL() {
        return "TOOL SortVcf.java: \"Sort VCF\" (Sort a VCF file by chromosome and position.)\nINPUT unsorted.vcf: \"VCF file\" TYPE GENERIC\nOUTPUT sorted.vcf: \"Sorted VCF file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.toolDescription.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.toolDescription.getOutputFiles().get(0).getFileName().getID());
            new TsvSorter().sort(inputFile, outputFile, VcfLineParser.Column.CHROM.ordinal(), VcfLineParser.Column.POS.ordinal(), new VcfLineParser());
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

