/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.TsvSorter;
import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import java.io.File;

public class SortBed
extends JavaCompJobBase {
    @Override
    public String getSADL() {
        return "TOOL SortBed.java: \"Sort BED\" (Sort a BED file by chromosome and start position.)\nINPUT regions.bed: \"BED file\" TYPE GENERIC\nOUTPUT sorted.bed: \"Sorted BED file\"\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "sorting");
        try {
            File inputFile = new File(this.jobWorkDir, this.toolDescription.getInputFiles().get(0).getFileName());
            File outputFile = new File(this.jobWorkDir, this.toolDescription.getOutputFiles().get(0).getFileName().getID());
            new TsvSorter().sort(inputFile, outputFile, BedLineParser.Column.CHROM.ordinal(), BedLineParser.Column.CHROM_START.ordinal(), new BedLineParser(false));
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "sorting finished");
    }
}

