/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.common;

import fi.csc.microarray.comp.java.JavaCompJobBase;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.KeyAndTrustManager;
import fi.csc.microarray.util.ToolUtils;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DownloadFile
extends JavaCompJobBase {
    public static final int CONNECTION_TIMEOUT = 15000;
    public static final int READ_TIMEOUT = 604800000;
    public static final List<String> allowedProtocols = Arrays.asList("http", "https", "ftp");
    public static final String CURRENT = "current";
    public static final String YES = "yes";
    public static final String NO = "no";

    @Override
    public String getSADL() {
        return "TOOL DownloadFile.java: \"Download file from URL directly to server\" (Download a file from a URL address to the Chipster server. The URL must be visible to Chipster server. If it's not, use client's 'Import from URL' functionality instead.)\nOUTPUT downloaded_file: \"Downloaded file\"\nPARAMETER paramUrl: \"URL\" TYPE STRING (URL to download)\nPARAMETER OPTIONAL paramFileExtension: \"Add a file extension\" TYPE [current: \"Keep current\", bam: \"BAM\", fa: \"FASTA\", fastq: \"FASTQ\", gtf: \"GTF\"] DEFAULT current (The output file is named according to the last part of the URL. If it doesn't contain a correct file extension, select it here so that the file type is recognized correctly.)\nPARAMETER OPTIONAL paramCheckCerts: \"Require valid SSL certificate\" TYPE [yes: \"Yes\", no: \"No\"] DEFAULT yes (Disable if the https server has a self-signed ssl certificate.)\n";
    }

    @Override
    protected void execute() {
        this.updateStateToClient(JobState.RUNNING, "downloading");
        try {
            URL url;
            File outputFile = new File(this.jobWorkDir, this.toolDescription.getOutputFiles().get(0).getFileName().getID());
            List<String> parameters = this.inputMessage.getParameters(JAVA_PARAMETER_SECURITY_POLICY, this.toolDescription);
            String urlString = parameters.get(0);
            String fileExtension = parameters.get(1);
            boolean checkCerts = true;
            if (NO.equals(parameters.get(2))) {
                checkCerts = false;
            }
            if (!allowedProtocols.contains((url = new URL(urlString)).getProtocol())) {
                this.getResultMessage().setErrorMessage("Unsupported protocol: " + url.getProtocol());
                this.updateState(JobState.FAILED_USER_ERROR, "");
                return;
            }
            if (UrlTransferUtil.isLocalhost(url.getHost())) {
                this.getResultMessage().setErrorMessage("Not allowed to connect localhost: " + url.getHost());
                this.updateState(JobState.FAILED_USER_ERROR, "");
                return;
            }
            String datasetName = UrlTransferUtil.parseFilename(url);
            if (!CURRENT.equals(fileExtension)) {
                datasetName = datasetName + "." + fileExtension;
            }
            URLConnection connection = url.openConnection();
            if (checkCerts) {
                KeyAndTrustManager.configureForCACertificates(connection);
            } else {
                KeyAndTrustManager.configureForTrustAllCertificates(connection);
            }
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(604800000);
            InputStream stream = connection.getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)outputFile);
            LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
            nameMap.put(outputFile.getName(), datasetName);
            ToolUtils.writeOutputDescription(this.jobWorkDir, nameMap);
        }
        catch (Exception e) {
            this.getResultMessage().setErrorMessage(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED, "");
            return;
        }
        this.updateStateToClient(JobState.RUNNING, "download finished");
    }
}

