/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import de.schlichtherle.truezip.file.TFileReader;
import fi.csc.chipster.toolbox.SADLTool;
import fi.csc.chipster.toolbox.Toolbox;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.chipster.toolbox.toolpartsparser.ToolPartsParser;
import fi.csc.chipster.util.StringUtils;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ToolboxModule {
    private static final Logger logger = Logger.getLogger(ToolboxModule.class);
    private LinkedList<ToolboxCategory> categories = new LinkedList();
    private LinkedHashMap<String, ToolboxTool> tools = new LinkedHashMap();
    private File moduleDir;
    private File moduleFile;
    private String summary = null;
    private String moduleName = null;

    public ToolboxModule(File moduleDir, File moduleFile) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        this.moduleFile = moduleFile;
        this.moduleDir = moduleDir;
        this.load();
    }

    public ModuleDescriptionMessage getModuleDescriptionMessage() {
        ModuleDescriptionMessage msg = new ModuleDescriptionMessage(this.moduleName);
        for (ToolboxCategory toolboxCategory : this.categories) {
            ModuleDescriptionMessage.Category category = new ModuleDescriptionMessage.Category(toolboxCategory.getName(), toolboxCategory.getColor(), toolboxCategory.isHidden());
            for (ToolboxTool tool : toolboxCategory.getTools()) {
                category.addTool(tool.getSadlString(), null);
            }
            msg.addCategory(category);
        }
        return msg;
    }

    public ToolboxTool getTool(String id) {
        return this.tools.get(id);
    }

    public Collection<ToolboxTool> getAll() {
        return this.tools.values();
    }

    public String getSummary() {
        return this.summary;
    }

    private void load() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        Document document = XmlUtil.parseReader((Reader)new TFileReader(this.moduleFile));
        Element moduleElement = (Element)document.getElementsByTagName("module").item(0);
        this.moduleName = moduleElement.getAttribute("name");
        if (this.moduleName.isEmpty()) {
            this.summary = "not loading a module without a name";
            logger.warn((Object)this.summary);
            return;
        }
        int totalCount = 0;
        int successfullyLoadedCount = 0;
        int hiddenCount = 0;
        int disabledCount = 0;
        for (Element categoryElement : XmlUtil.getChildElements(moduleElement, "category")) {
            String categoryName = categoryElement.getAttribute("name");
            if (categoryName.isEmpty()) {
                logger.warn((Object)"not loading a category without a name");
                continue;
            }
            boolean categoryDisabled = categoryElement.getAttribute("disabled").equals("true");
            if (categoryDisabled) {
                logger.info((Object)("not loading category " + categoryName + ": disabled"));
                continue;
            }
            String categoryColor = categoryElement.getAttribute("color");
            if (categoryColor.isEmpty()) {
                logger.warn((Object)("not loading category " + categoryName + ": no color"));
                continue;
            }
            boolean categoryHidden = Boolean.valueOf(categoryElement.getAttribute("hidden"));
            ToolboxCategory category = new ToolboxCategory(categoryName, categoryColor, categoryHidden);
            this.categories.add(category);
            for (Element toolElement : XmlUtil.getChildElements(categoryElement, "tool")) {
                SADLDescription sadlDescription;
                SADLTool.ParsedScript parsedScript;
                ++totalCount;
                Element resourceElement = XmlUtil.getChildElement(toolElement, "resource");
                if (resourceElement == null) {
                    logger.warn((Object)"not loading a tool without resource element");
                    continue;
                }
                String resource = resourceElement.getTextContent().trim();
                if (resource == null || resource.isEmpty()) {
                    logger.warn((Object)"not loading a tool with empty resource element");
                    continue;
                }
                boolean toolHidden = categoryHidden;
                String runtimeName = toolElement.getAttribute("runtime");
                if (runtimeName == null || runtimeName.isEmpty()) {
                    logger.warn((Object)("not loading " + resource + ": runtime " + runtimeName + " is null or empty"));
                    continue;
                }
                String nonDefaultModuleName = toolElement.getAttribute("module");
                File toolModuleDir = nonDefaultModuleName != null && !nonDefaultModuleName.equals("") ? new File(this.moduleDir.getParentFile(), nonDefaultModuleName) : this.moduleDir;
                boolean parametersOk = true;
                HashMap<String, String> parameters = new HashMap<String, String>();
                for (Element parameterElement : XmlUtil.getChildElements(toolElement, "parameter")) {
                    String parameterName = XmlUtil.getChildElement(parameterElement, "name").getTextContent().trim();
                    if (parameterName == null || parameterName.isEmpty()) {
                        logger.warn((Object)"parameter without a name");
                        parametersOk = false;
                        break;
                    }
                    String parameterValue = XmlUtil.getChildElement(parameterElement, "value").getTextContent().trim();
                    if (parameterValue == null) {
                        logger.warn((Object)"parameter without a value");
                        parametersOk = false;
                        break;
                    }
                    parameters.put(parameterName, parameterValue);
                }
                if (!parametersOk) {
                    logger.warn((Object)("not loading " + resource + ": parameters not ok"));
                    continue;
                }
                ToolPartsParser partsParser = Toolbox.getToolPartsParser(runtimeName);
                if (partsParser == null) {
                    logger.warn((Object)("not loading " + resource + ": no parser for runtime " + runtimeName));
                    continue;
                }
                try {
                    parsedScript = partsParser.parse(toolModuleDir, resource);
                }
                catch (Exception e) {
                    logger.warn((Object)("loading " + resource + " failed, parsing parts failed"), (Throwable)e);
                    continue;
                }
                try {
                    sadlDescription = new ChipsterSADLParser().parse(parsedScript.SADL);
                }
                catch (SADLParser.ParseException e) {
                    logger.warn((Object)("loading " + resource + " failed, parsing sadl failed"), (Throwable)e);
                    continue;
                }
                String toolId = sadlDescription.getName().getID();
                boolean filenamesOk = true;
                HashSet<String> uniqueNames = new HashSet<String>();
                ArrayList<String> allNames = new ArrayList<String>();
                for (SADLDescription.Input input : sadlDescription.getInputs()) {
                    allNames.add(input.getName().getID());
                }
                for (SADLDescription.Output output : sadlDescription.getOutputs()) {
                    allNames.add(output.getName().getID());
                }
                for (String name : allNames) {
                    if (name == null) continue;
                    if (uniqueNames.contains(name)) {
                        logger.warn((Object)("filename " + name + " isn't unique"));
                        filenamesOk = false;
                        continue;
                    }
                    uniqueNames.add(name);
                }
                if (!filenamesOk) {
                    logger.warn((Object)("not loading " + resource + ": non-unique filename(s)"));
                    continue;
                }
                ToolboxTool toolboxTool = new ToolboxTool(toolId, sadlDescription, parsedScript.SADL, parsedScript.code, parsedScript.source, resource, this.moduleDir.getName(), runtimeName);
                this.tools.put(toolId, toolboxTool);
                ++successfullyLoadedCount;
                category.addTool(toolboxTool);
                String hiddenStatus = "";
                if (toolHidden) {
                    hiddenStatus = "HIDDEN";
                    ++hiddenCount;
                }
                logger.debug((Object)String.format("loaded %s %s from %s %s", toolId, sadlDescription.getName().getDisplayName(), resource, hiddenStatus));
            }
        }
        this.summary = "loaded " + this.moduleName + " " + successfullyLoadedCount + "/" + totalCount + " tools, " + disabledCount + " disabled, " + hiddenCount + " hidden";
        logger.info((Object)this.summary);
    }

    public String getName() {
        return this.moduleName;
    }

    public String getNamePretty() {
        if (this.moduleName.equals("ngs")) {
            return this.moduleName.toUpperCase();
        }
        return StringUtils.capitalizeFirstLetter(this.moduleName);
    }

    public List<ToolboxCategory> getCategories() {
        return this.categories;
    }

    public static class ToolboxCategory {
        private String name;
        private String color;
        private Boolean hidden;
        private List<ToolboxTool> tools = new LinkedList<ToolboxTool>();

        public ToolboxCategory(String name, String color, Boolean hidden) {
            this.name = name;
            this.color = color;
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean isHidden() {
            return this.hidden;
        }

        public void addTool(ToolboxTool tool) {
            this.tools.add(tool);
        }

        public List<ToolboxTool> getTools() {
            return this.tools;
        }
    }
}

