/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import de.schlichtherle.truezip.file.TFile;
import fi.csc.chipster.toolbox.ToolboxModule;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.chipster.toolbox.toolpartsparser.HeaderAsCommentParser;
import fi.csc.chipster.toolbox.toolpartsparser.JavaParser;
import fi.csc.chipster.toolbox.toolpartsparser.ToolPartsParser;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class Toolbox {
    private static final Logger logger = Logger.getLogger(Toolbox.class);
    private static final String MODULES_DIR_NAME = "modules";
    private static final String TOOLS_DIST_BASENAME = "chipster-tools";
    private List<ToolboxModule> modules = new LinkedList<ToolboxModule>();
    private File modulesDir = null;

    public Toolbox(File modulesDir) throws IOException, URISyntaxException {
        TFile rootDir = new TFile(".").getCanonicalFile();
        this.findModulesDir(modulesDir, (File)rootDir);
        this.loadModuleDescriptions();
    }

    public ToolboxTool getTool(String id) {
        for (ToolboxModule module : this.modules) {
            ToolboxTool tool = module.getTool(id);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public List<ToolboxTool> getAll() {
        LinkedList<ToolboxTool> list = new LinkedList<ToolboxTool>();
        for (ToolboxModule module : this.modules) {
            list.addAll(module.getAll());
        }
        return list;
    }

    public List<ToolboxModule> getModules() {
        return this.modules;
    }

    public ToolboxModule getModule(String name) {
        for (ToolboxModule module : this.modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public List<ModuleDescriptionMessage> getModuleDescriptions() {
        LinkedList<ModuleDescriptionMessage> moduleDescriptions = new LinkedList<ModuleDescriptionMessage>();
        for (ToolboxModule module : this.modules) {
            moduleDescriptions.add(module.getModuleDescriptionMessage());
        }
        return moduleDescriptions;
    }

    private void findModulesDir(File modulesDir, File rootDir) throws IOException, FileNotFoundException, URISyntaxException {
        logger.info((Object)("looking for modules dir " + modulesDir.getAbsolutePath()));
        if (modulesDir.exists() && modulesDir.isDirectory()) {
            this.modulesDir = modulesDir;
            logger.info((Object)("modules dir " + modulesDir.getAbsolutePath() + " found"));
        } else {
            logger.info((Object)("modules dir " + modulesDir.getAbsolutePath() + " not found"));
            logger.info((Object)("looking for chipster-tools-x.y.z dir in " + rootDir));
            File toolsDir = Files.getLatestVersion(rootDir, TOOLS_DIST_BASENAME, null);
            if (toolsDir != null && toolsDir.exists()) {
                logger.info((Object)("found " + toolsDir));
                logger.info((Object)("looking for " + toolsDir.getAbsolutePath() + File.separator + MODULES_DIR_NAME));
                File possibleModulesDir = new File(toolsDir, MODULES_DIR_NAME);
                if (possibleModulesDir.exists() && possibleModulesDir.isDirectory()) {
                    this.modulesDir = possibleModulesDir;
                    logger.info((Object)("modules dir " + this.modulesDir + " found"));
                } else {
                    logger.info((Object)("modules dir " + possibleModulesDir + " not found"));
                }
            } else {
                logger.info((Object)(rootDir + File.separator + TOOLS_DIST_BASENAME + "-x.y.z dir not found"));
            }
            if (this.modulesDir == null) {
                logger.info((Object)("looking for " + new File(rootDir, "chipster-tools-x.y.z.tar.gz")));
                File toolsTar = Files.getLatestVersion(rootDir, TOOLS_DIST_BASENAME, "tar.gz");
                this.loadFromTar(toolsTar);
            }
            if (this.modulesDir == null) {
                URL url = this.getClass().getResource("/");
                File lib = new File(url.toURI());
                logger.info((Object)("looking for " + new File(lib, "chipster-tools-x.y.z.tar.gz")));
                File toolsTar = Files.getLatestVersion(lib, TOOLS_DIST_BASENAME, "tar.gz");
                this.loadFromTar(toolsTar);
            }
        }
        if (this.modulesDir == null) {
            String s = String.format("no %s dir found after looking for: " + rootDir + File.separator + "%s, " + rootDir + File.separator + TOOLS_DIST_BASENAME + "-x.y.z/%s, " + rootDir + File.separator + TOOLS_DIST_BASENAME + "-x.y.z.tar.gz" + File.separator + TOOLS_DIST_BASENAME + "-x.y.z/%s, " + new File(this.getClass().getResource("/").toURI()) + File.separator + TOOLS_DIST_BASENAME + "-x.y.z" + ".tar.gz/%s", MODULES_DIR_NAME, MODULES_DIR_NAME, MODULES_DIR_NAME, MODULES_DIR_NAME, MODULES_DIR_NAME);
            logger.error((Object)s);
            throw new FileNotFoundException(s);
        }
        logger.info((Object)("loading modules from " + this.modulesDir.getCanonicalPath()));
    }

    private void loadFromTar(File toolsTar) {
        if (toolsTar != null && toolsTar.exists()) {
            logger.info((Object)("found " + toolsTar));
            logger.info((Object)("looking for " + toolsTar.getAbsolutePath() + File.separator + TOOLS_DIST_BASENAME + "-x.y.z" + File.separator + MODULES_DIR_NAME));
            TFile distFile = new TFile(toolsTar);
            TFile toolsDirInTar = new TFile(Files.getLatestVersion((File)distFile, TOOLS_DIST_BASENAME, null));
            if (toolsDirInTar != null && toolsDirInTar.exists()) {
                TFile possibleModulesDir = new TFile((File)toolsDirInTar, MODULES_DIR_NAME);
                if (possibleModulesDir.exists() && possibleModulesDir.isDirectory()) {
                    this.modulesDir = possibleModulesDir;
                    logger.info((Object)("modules dir " + this.modulesDir + " found"));
                } else {
                    logger.info((Object)("modules dir " + possibleModulesDir + " not found"));
                }
            } else {
                logger.info((Object)("no " + toolsTar.getAbsolutePath() + ":" + TOOLS_DIST_BASENAME + "-x.y.z found"));
            }
        }
    }

    private void loadModuleDescriptions() throws IOException {
        LinkedList<String> moduleLoadSummaries = new LinkedList<String>();
        for (String moduleDirName : this.modulesDir.list()) {
            TFile moduleDir = new TFile(this.modulesDir, moduleDirName);
            if (!moduleDir.isDirectory()) continue;
            for (String moduleFilename : moduleDir.list()) {
                String summary;
                ToolboxModule module;
                TFile moduleFile;
                if (!moduleFilename.endsWith("-module.xml") || !(moduleFile = new TFile((File)moduleDir, moduleFilename)).exists()) continue;
                logger.info((Object)("loading tools specifications from: " + moduleFilename));
                try {
                    module = new ToolboxModule((File)moduleDir, (File)moduleFile);
                    summary = module.getSummary();
                }
                catch (Exception e) {
                    logger.warn((Object)("loading " + moduleFilename + " failed"), (Throwable)e);
                    continue;
                }
                this.modules.add(module);
                moduleLoadSummaries.add(summary);
            }
        }
        logger.info((Object)"------ tool summary ------ ");
        for (String summary : moduleLoadSummaries) {
            logger.info((Object)summary);
        }
        logger.info((Object)"------ tool summary ------ ");
    }

    static ToolPartsParser getToolPartsParser(String runtime) {
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        if (runtime.startsWith("python")) {
            return new HeaderAsCommentParser("#", runtime);
        }
        if (runtime.startsWith("java")) {
            return new JavaParser();
        }
        if (runtime.startsWith("R")) {
            return new HeaderAsCommentParser("#", runtime);
        }
        return null;
    }
}

