/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.pedigree;

import net.sf.picard.pedigree.PedFile;
import net.sf.picard.pedigree.Sex;

public class PedTrio {
    public static final Number NO_PHENO = new Integer(-9);
    public static final Sex UNKNOWN_SEX = Sex.Unknown;
    private final String familyId;
    private final String individualId;
    private final String paternalId;
    private final String maternalId;
    private final Sex sex;
    private final Number phenotype;

    public PedTrio(String familyId, String individualId, String paternalId, String maternalId, Sex sex, Number phenotype) {
        if (PedFile.WHITESPACE.split(familyId).length != 1) {
            throw new IllegalArgumentException("FamilyID     cannot contain whitespace: [" + familyId + "]");
        }
        if (PedFile.WHITESPACE.split(individualId).length != 1) {
            throw new IllegalArgumentException("IndividualID cannot contain whitespace: [" + individualId + "]");
        }
        if (PedFile.WHITESPACE.split(paternalId).length != 1) {
            throw new IllegalArgumentException("PaternalID   cannot contain whitespace: [" + paternalId + "]");
        }
        if (PedFile.WHITESPACE.split(maternalId).length != 1) {
            throw new IllegalArgumentException("MaternalID   cannot contain whitespace: [" + maternalId + "]");
        }
        this.familyId = familyId;
        this.individualId = individualId;
        this.paternalId = paternalId;
        this.maternalId = maternalId;
        this.sex = sex;
        this.phenotype = phenotype;
    }

    public boolean hasBothParents() {
        return this.paternalId != null && this.maternalId != null;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getPaternalId() {
        return this.paternalId;
    }

    public String getMaternalId() {
        return this.maternalId;
    }

    public Sex getSex() {
        return this.sex;
    }

    public Number getPhenotype() {
        return this.phenotype;
    }
}

