/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.samtools.util.StringUtil;

public class Casava18ReadNameEncoder
implements ReadNameEncoder {
    static final int CONTROL_FIELD_VALUE = 0;
    final String runId;
    final String instrumentName;
    final String flowcellId;

    public Casava18ReadNameEncoder(String instrumentName, String runId, String flowcellId) {
        this.runId = runId;
        this.instrumentName = instrumentName;
        this.flowcellId = flowcellId;
    }

    @Override
    public String generateReadName(ClusterData cluster, Integer pairNumber) {
        return String.format("%s:%s:%s:%d:%d:%d:%d %s:%s:%d:%s", new Object[]{this.instrumentName, this.runId, this.flowcellId, cluster.getLane(), cluster.getTile(), cluster.getX(), cluster.getY(), StringUtil.asEmptyIfNull((Object)pairNumber), PassesFilterLabel.get(cluster.isPf()), 0, StringUtil.asEmptyIfNull((Object)cluster.getMatchedBarcode())});
    }

    static enum PassesFilterLabel {
        Y,
        N;


        static PassesFilterLabel get(boolean passesFilter) {
            return passesFilter ? Y : N;
        }
    }
}

