/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.util.ServiceHelper;

public class EmptyProducerCache
extends ProducerCache {
    public EmptyProducerCache(Object source, CamelContext camelContext) {
        super(source, camelContext, 0);
    }

    @Override
    public Producer acquireProducer(Endpoint endpoint) {
        Producer answer = null;
        try {
            answer = endpoint.createProducer();
            ServiceHelper.startService(answer);
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(endpoint, (Throwable)e);
        }
        return answer;
    }

    @Override
    public void releaseProducer(Endpoint endpoint, Producer producer) throws Exception {
        ServiceHelper.stopAndShutdownService(producer);
    }

    @Override
    public String toString() {
        return "EmptyProducerCache for source: " + this.getSource();
    }
}

