/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileRenameExclusiveReadLockStrategy<T>
implements GenericFileExclusiveReadLockStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileRenameExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;

    @Override
    public void prepareOnStartup(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint) throws Exception {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<T> operations, GenericFile<T> file, Exchange exchange) throws Exception {
        LOG.trace("Waiting for exclusive read lock to file: {}", file);
        String newName = file.getFileName() + ".camelExclusiveReadLock";
        GenericFile<T> newFile = file.copyFrom(file);
        newFile.changeFileName(newName);
        StopWatch watch = new StopWatch();
        boolean exclusive = false;
        while (!exclusive) {
            long delta;
            if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                CamelLogger.log(LOG, this.readLockLoggingLevel, "Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file);
                return false;
            }
            exclusive = operations.renameFile(file.getAbsoluteFilePath(), newFile.getAbsoluteFilePath());
            if (exclusive) {
                LOG.trace("Acquired exclusive read lock to file: {}", file);
                operations.renameFile(newFile.getAbsoluteFilePath(), file.getAbsoluteFilePath());
                continue;
            }
            boolean interrupted = this.sleep();
            if (!interrupted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<T> operations, GenericFile<T> file, Exchange exchange) throws Exception {
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }
}

