/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.EmptyClassVisitor;
import org.sonatype.guice.bean.scanners.asm.AnnotationVisitor;
import org.sonatype.guice.bean.scanners.asm.Type;

final class QualifierCache
extends EmptyClassVisitor {
    private static final String QUALIFIER_DESC = Type.getDescriptor(Qualifier.class);
    private static final ConcurrentHashMap<String, Boolean> cachedResults = new ConcurrentHashMap(32, 0.75f, 1);
    private boolean isQualified;

    QualifierCache() {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }

    boolean qualify(ClassSpace space, String desc) {
        Boolean result = cachedResults.get(desc);
        if (null == result) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            ClassSpaceScanner.accept(this, space.getResource(name + ".class"));
            cachedResults.putIfAbsent(desc, this.isQualified);
            return this.isQualified;
        }
        return result;
    }
}

