/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.hc;

import org.jfree.data.general.AbstractDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;

public class HCDataset
extends AbstractDataset {
    private HeatMap heatMap;
    private HCTreeNode rowTree;
    private HCTreeNode columnTree;

    public HCDataset(HeatMap heatMap, HCTreeNode rowTree, HCTreeNode columnTree) throws IllegalArgumentException, NullPointerException {
        if (heatMap == null) {
            throw new NullPointerException("HeatMap given to HCDataset() was null.");
        }
        this.rowTree = rowTree;
        this.columnTree = columnTree;
        this.heatMap = heatMap;
        if (this.rowTree != null && this.heatMap.getRowCount() != this.rowTree.getDataRange().getWidth()) {
            throw new IllegalArgumentException("Left tree doesn't match heatmap height.");
        }
        if (this.columnTree != null && this.heatMap.getColumnsCount() != this.columnTree.getDataRange().getWidth()) {
            throw new IllegalArgumentException("Top tree doesn't match heatmap width.");
        }
        if (this.rowTree != null) {
            this.rowTree.finalizeTree();
        }
        if (this.columnTree != null) {
            this.columnTree.finalizeTree();
        }
    }

    public HeatMap getHeatMap() {
        return this.heatMap;
    }

    public HCTreeNode getColumnClusteringTree() {
        return this.columnTree;
    }

    public HCTreeNode getRowClusteringTree() {
        return this.rowTree;
    }
}

