/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.http;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsAbstractController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.http.HttpDriver;
import de.schlichtherle.truezip.fs.http.HttpEntry;
import de.schlichtherle.truezip.fs.http.ReadOnlyFileSystemTypeException;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpResponse;

@Immutable
public class HttpController
extends FsAbstractController<FsModel> {
    private final HttpDriver driver;

    HttpController(HttpDriver driver, FsModel model) {
        super(model);
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        assert (null != driver);
        this.driver = driver;
    }

    final IOPool<?> getPool() {
        return this.driver.getPool();
    }

    final HttpResponse executeHead(HttpEntry entry) throws IOException {
        return this.driver.executeHead(entry);
    }

    final HttpResponse executeGet(HttpEntry entry) throws IOException {
        return this.driver.executeGet(entry);
    }

    protected HttpEntry newEntry(FsEntryName name) {
        return new HttpEntry(this, name);
    }

    final FsPath resolve(FsEntryName name) {
        return this.getMountPoint().resolve(name);
    }

    @Override
    public FsController<?> getParent() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return false;
    }

    @Override
    public HttpEntry getEntry(FsEntryName name) throws IOException {
        HttpEntry entry = this.newEntry(name);
        return entry.isType(Entry.Type.FILE) ? entry : null;
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        return null != this.getEntry(name);
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        return false;
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return this.newEntry(name).newInputSocket(options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return this.newEntry(name).newOutputSocket(options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        throw new ReadOnlyFileSystemTypeException();
    }

    @Override
    public void sync(BitField<FsSyncOption> options) {
    }
}

