/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

class Address {
    private String _address;
    private boolean _passive;
    private String _scheme;
    private String _user;
    private String _pass;
    private String _host;
    private String _port;
    private String _name;

    public Address(String address) {
        this._address = address;
        this.parse();
    }

    private void parse() {
        int close;
        String hp;
        String uphp;
        int slash;
        this._passive = false;
        this._scheme = null;
        this._user = null;
        this._pass = null;
        this._host = null;
        this._port = null;
        this._name = null;
        int start = 0;
        int schemeEnd = this._address.indexOf("://", start);
        if (schemeEnd >= 0) {
            this._scheme = this._address.substring(start, schemeEnd);
            start = schemeEnd + 3;
        }
        if ((slash = this._address.indexOf("/", start)) > 0) {
            uphp = this._address.substring(start, slash);
            this._name = this._address.substring(slash + 1);
        } else {
            uphp = this._address.substring(start);
        }
        int at = uphp.indexOf(64);
        if (at >= 0) {
            String up = uphp.substring(0, at);
            hp = uphp.substring(at + 1);
            int colon = up.indexOf(58);
            if (colon >= 0) {
                this._user = up.substring(0, colon);
                this._pass = up.substring(colon + 1);
            } else {
                this._user = up;
            }
        } else {
            hp = uphp;
        }
        if (hp.startsWith("[") && (close = hp.indexOf(93)) >= 0) {
            this._host = hp.substring(1, close);
            if (hp.substring(close + 1).startsWith(":")) {
                this._port = hp.substring(close + 2);
            }
        }
        if (this._host == null) {
            int colon = hp.indexOf(58);
            if (colon >= 0) {
                this._host = hp.substring(0, colon);
                this._port = hp.substring(colon + 1);
            } else {
                this._host = hp;
            }
        }
        if (this._host.startsWith("~")) {
            this._host = this._host.substring(1);
            this._passive = true;
        }
    }

    public String toString() {
        return this._address;
    }

    public boolean isPassive() {
        return this._passive;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getUser() {
        return this._user;
    }

    public String getPass() {
        return this._pass;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getImpliedPort() {
        if (this._port == null) {
            return this.getDefaultPort();
        }
        return this.getPort();
    }

    public String getDefaultPort() {
        if ("amqps".equals(this._scheme)) {
            return "5671";
        }
        return "5672";
    }

    public String getName() {
        return this._name;
    }
}

