/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.linkedin.util.reflect.ObjectProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    public static final String MODULE = ReflectUtils.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private static final Method CLONE_METHOD;

    public static Object getProxiedObject(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
            if (invocationHandler instanceof ObjectProxy) {
                ObjectProxy objectProxy = (ObjectProxy)((Object)invocationHandler);
                return ReflectUtils.getProxiedObject(objectProxy.getProxiedObject());
            }
            return proxy;
        }
        return proxy;
    }

    public static <T> T clone(T object) throws CloneNotSupportedException {
        if (!(object instanceof Cloneable)) {
            throw new CloneNotSupportedException();
        }
        try {
            return (T)CLONE_METHOD.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            CloneNotSupportedException ex = new CloneNotSupportedException();
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (CloneNotSupportedException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl;
        block3: {
            cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Cannot access thread context ClassLoader - falling back to system class loader", ex);
            }
        }
        if (cl == null) {
            cl = ReflectUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Class forName(String name) throws ClassNotFoundException, LinkageError {
        return ReflectUtils.forName(name, ReflectUtils.getDefaultClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        if (classLoader == null) {
            classLoader = ReflectUtils.getDefaultClassLoader();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class forName(Class clazz, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        if (clazz == null) {
            return null;
        }
        if (classLoader == null) {
            classLoader = ReflectUtils.getDefaultClassLoader();
        }
        if (clazz.getClassLoader() == null || clazz.getClassLoader().equals(classLoader)) {
            return clazz;
        }
        return ReflectUtils.forName(clazz.getName(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithClassLoader(ClassLoader classLoader, Callable<T> callable) throws Exception {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    public static String computeSignature(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName()).append('(');
        Class<?>[] parameterTypes = m.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Class<?> parameterType = parameterTypes[i];
            sb.append(parameterType.getName());
        }
        sb.append(')');
        return sb.toString();
    }

    public static Class[] extractAllInterfaces(Object o) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> c = o.getClass();
        do {
            interfaces.addAll(Arrays.asList(c.getInterfaces()));
        } while ((c = c.getSuperclass()) != null);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static boolean isSubClassOrInterfaceOf(Class subclass, Class superclass) {
        return superclass.isAssignableFrom(subclass);
    }

    private ReflectUtils() {
    }

    static {
        try {
            CLONE_METHOD = Object.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

