/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.lang.reflect.Method;

public class BrowserLauncher {
    private static final String[] UNIX_BROWSERS = new String[]{"firefox", "seamonkey", "mozilla", "konqueror", "opera", "epiphany", "netscape"};

    public static void openURL(String url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String availableBrowser = null;
            for (String browser : UNIX_BROWSERS) {
                if (Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() != 0) continue;
                availableBrowser = browser;
                break;
            }
            if (availableBrowser != null) {
                Runtime.getRuntime().exec(new String[]{availableBrowser, url});
            } else {
                throw new Exception("Could not find web browser");
            }
        }
    }
}

