/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.comp.ToolDescription;
import fi.csc.microarray.messaging.message.GenericJobMessage;
import fi.csc.microarray.messaging.message.JobMessageUtils;
import fi.csc.microarray.messaging.message.PayloadMessage;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class JobMessage
extends PayloadMessage
implements GenericJobMessage {
    private static final Logger logger = Logger.getLogger(JobMessage.class);
    private static final String KEY_JOB_ID = "jobID";
    private static final String KEY_TOOL_ID = "analysisID";
    private String toolId;
    private String jobId;

    public JobMessage() {
    }

    public JobMessage(String jobId, String toolId, List<String> parameters) {
        super(parameters);
        this.jobId = jobId;
        this.toolId = toolId;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.jobId = from.getString(KEY_JOB_ID);
        this.toolId = from.getString(KEY_TOOL_ID);
        logger.debug((Object)("Unmarshalled jobID : " + this.jobId));
        logger.debug((Object)("Unmarshalled analysisID : " + this.toolId));
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        logger.debug((Object)("Marshalling: jobID : " + this.jobId));
        logger.debug((Object)("Marshalling: analysisID : " + this.toolId));
        mapMessage.setString(KEY_JOB_ID, this.jobId);
        mapMessage.setString(KEY_TOOL_ID, this.toolId);
    }

    @Override
    public String getToolId() {
        return this.toolId;
    }

    public void setToolId(String id) {
        this.toolId = id;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public List<String> getParameters(ParameterSecurityPolicy securityPolicy, ToolDescription description) throws ParameterValidityException {
        return JobMessageUtils.checkParameterSafety(securityPolicy, description, super.getParameters());
    }

    @Override
    public UUID getSessionId() {
        return null;
    }

    @Override
    public void preExecute(File jobWorkDir) {
    }

    public static class ParameterValidityException
    extends Exception {
        public ParameterValidityException(String msg) {
            super(msg);
        }
    }

    public static abstract class ParameterSecurityPolicy {
        public abstract boolean isValueValid(String var1, ToolDescription.ParameterDescription var2);

        public boolean allowUncheckedParameters() {
            return false;
        }
    }
}

