/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProvider;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.handlers.ContentHandler;
import fi.csc.microarray.databeans.handlers.LocalFileContentHandler;
import fi.csc.microarray.databeans.handlers.RemoteContentHandler;
import fi.csc.microarray.databeans.handlers.ZipContentHandler;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.ContentLengthException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.util.ThreadUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.IO;

public class DataManager {
    private static final String AT_LEAST_ROWS_CACHENAME = "at-least-rows";
    public static final int MAX_ROWS_TO_COUNT = 1000;
    public static final int MAX_BYTES_TO_COUNT = 102400;
    public static final String DATA_NA_INFOTEXT = "Data currently not available";
    private static final String TEMP_DIR_PREFIX = "chipster";
    private static final int MAX_FILENAME_LENGTH = 256;
    private static final Logger logger = Logger.getLogger(DataManager.class);
    public static final String ROOT_NAME = "Datasets";
    private Map<String, FeatureProvider> factories = new HashMap<String, FeatureProvider>();
    private Map<String, Modifier> modifiers = new HashMap<String, Modifier>();
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private LinkedList<DataChangeListener> listeners = new LinkedList();
    private boolean eventsEnabled = false;
    private DataFolder rootFolder;
    private File repositoryRoot;
    private LinkedList<Module> modules;
    private ZipContentHandler zipContentHandler = new ZipContentHandler();
    private LocalFileContentHandler localFileContentHandler = new LocalFileContentHandler();
    private RemoteContentHandler remoteContentHandler = new RemoteContentHandler();
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    public DataManager() throws Exception {
        this.rootFolder = this.createFolder(ROOT_NAME);
        this.repositoryRoot = this.createRepository();
    }

    public void setRootFolder(DataFolder folder) {
        this.rootFolder = folder;
    }

    public File getRepository() {
        return this.repositoryRoot;
    }

    public DataFolder getRootFolder() {
        return this.rootFolder;
    }

    public boolean isRootFolder(DataFolder folder) {
        return this.rootFolder == folder && this.rootFolder != null;
    }

    public DataFolder createFolder(String name) {
        DataFolder folder = new DataFolder(this, name);
        return folder;
    }

    public DataFolder createFolder(DataFolder root, String name) {
        DataFolder folder = new DataFolder(this, name);
        this.connectChild(folder, root);
        return folder;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        logger.debug((Object)("adding DataChangeListener: " + listener));
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listeners.add(listener);
    }

    public synchronized File createNewRepositoryFile(String beanName) throws IOException {
        String fileName = beanName.replaceAll("[^\\w\\.\\-_]", "");
        if (fileName.length() < 1) {
            fileName = "data";
        } else if (fileName.length() > 256) {
            fileName = fileName.substring(0, 256);
        }
        File file = new File(this.repositoryRoot, fileName);
        int indexOfDot = fileName.lastIndexOf(".");
        String newFileName = "";
        for (int i = 1; file.exists() && i < Integer.MAX_VALUE; ++i) {
            newFileName = indexOfDot < 0 ? fileName + "-" + i : fileName.substring(0, indexOfDot) + "-" + i + fileName.substring(indexOfDot, fileName.length());
            file = new File(this.repositoryRoot, newFileName);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create file " + fileName);
        }
        file.deleteOnExit();
        return file;
    }

    private File createRepository() throws IOException {
        File tempRoot = this.getTempRoot();
        if (!tempRoot.canWrite()) {
            throw new IOException("Could not create repository directory.");
        }
        String fileName = TEMP_DIR_PREFIX;
        File repository = new File(tempRoot, fileName);
        boolean repositoryCreated = false;
        for (int i = 1; !repositoryCreated && i < 1000; ++i) {
            repositoryCreated = repository.mkdir();
            if (repositoryCreated) continue;
            repository = new File(tempRoot, fileName + "-" + i);
        }
        if (!repositoryCreated) {
            throw new IOException("Could not create repository directory.");
        }
        repository.deleteOnExit();
        return repository;
    }

    private File getTempRoot() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.canWrite() && !(tempDir = new File(System.getProperty("user.home"))).canWrite()) {
            tempDir = new File(System.getProperty("user.dir"));
        }
        return tempDir;
    }

    public void setEventsEnabled(boolean enabled) {
        this.eventsEnabled = enabled;
    }

    public void dispatchEventIfVisible(DataChangeEvent event) {
        if (event.getDataItem().getParent() != null) {
            this.dispatchEvent(event);
        }
    }

    public void dispatchEvent(DataChangeEvent event) {
        if (this.eventsEnabled) {
            for (DataChangeListener listener : this.listeners) {
                if (listener == null) {
                    logger.error((Object)"One of the DataChangeListeners listeners was null.");
                } else {
                    logger.debug((Object)("Notifying DataChangeListener " + listener.toString()));
                }
                try {
                    listener.dataChanged(event);
                }
                catch (RuntimeException e) {
                    logger.error((Object)"DataChangeEvent dispatch failed", (Throwable)e);
                }
            }
        }
    }

    public static DataBean[] wrapSource(DataBean source) {
        DataBean[] sources = null;
        sources = source != null ? new DataBean[]{source} : new DataBean[]{};
        return sources;
    }

    public ContentType guessContentType(String name) {
        String extension;
        String typeName;
        ContentType type = null;
        if (name.lastIndexOf(".") != -1 && (typeName = this.extensionMap.get(extension = name.substring(name.lastIndexOf(".") + 1, name.length()).toLowerCase())) != null) {
            type = this.contentTypes.get(typeName);
        }
        if (type == null) {
            type = this.contentTypes.get("application/octet-stream");
        }
        return type;
    }

    public ContentType guessContentType(File file) {
        return this.guessContentType(file.getName());
    }

    public ContentType getContentType(String typeName) {
        return this.contentTypes.get(typeName);
    }

    public void plugContentType(String mimeType, boolean supported, boolean binary, String description, String iconPath, String ... extensions) {
        this.contentTypes.put(mimeType, new ContentType(mimeType, supported, binary, description, iconPath, extensions));
        for (String extension : extensions) {
            this.extensionMap.put(extension, mimeType);
        }
    }

    public void plugModifier(String name, Modifier modifier) {
        this.modifiers.put(name, modifier);
    }

    public void plugFeatureFactory(String name, FeatureProvider plugin) {
        logger.debug((Object)("plugged " + plugin.getClass().getSimpleName() + " at " + name));
        plugin.setName(name);
        this.factories.put(name, plugin);
    }

    public Modifier fetchModifier(String modifierName) {
        return this.modifiers.get(modifierName);
    }

    public Feature fetchFeature(String featureName, DataBean bean) {
        String bestMatch = null;
        for (String feature : this.factories.keySet()) {
            if (!featureName.startsWith(feature) || bestMatch != null && feature.length() <= bestMatch.length()) continue;
            bestMatch = feature;
        }
        FeatureProvider factory = this.factories.get(bestMatch);
        if (factory == null) {
            throw new RuntimeException("no feature factory plugged in for \"" + featureName + "\" (total of " + this.factories.size() + " factories plugged)");
        }
        logger.debug((Object)("best match for " + featureName + " was " + (factory != null ? factory.getName() : factory)));
        String namePostfix = this.getNamePostfix(featureName, factory.getName());
        return factory.createFeature(namePostfix, bean);
    }

    public DataItem findDataItem(String name) {
        return this.findDataItem(name, this.getRootFolder());
    }

    private DataItem findDataItem(String name, DataItem root) {
        DataItem matchingItem = null;
        if (root.getName().equals(name)) {
            return root;
        }
        if (root instanceof DataFolder) {
            for (DataItem child : ((DataFolder)root).getChildren()) {
                matchingItem = this.findDataItem(name, child);
                if (matchingItem == null) continue;
                return matchingItem;
            }
        }
        return null;
    }

    public DataBean getDataBean(String name) {
        for (DataBean dataBean : this.databeans()) {
            if (!dataBean.getName().equals(name)) continue;
            return dataBean;
        }
        return null;
    }

    public LinkedList<DataBean> getDataBeans(String name) {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        for (DataBean dataBean : this.databeans()) {
            if (!dataBean.getName().equals(name)) continue;
            list.add(dataBean);
        }
        return list;
    }

    public DataBean createLocalTempDataBean(String name) throws MicroarrayException {
        try {
            File contentFile = this.createNewRepositoryFile(name);
            DataBean bean = this.createDataBean(name);
            this.addContentLocationForDataBean(bean, StorageMethod.LOCAL_TEMP, contentFile.toURI().toURL());
            return bean;
        }
        catch (ContentLengthException | IOException e) {
            throw new MicroarrayException(e);
        }
    }

    public DataBean createDataBean(String name) throws MicroarrayException {
        DataBean data = new DataBean(name, this.guessContentType(name), this);
        return data;
    }

    public DataBean createDataBean(String name, String dataId, boolean updateContentLength) throws MicroarrayException {
        DataBean data = new DataBean(name, this.guessContentType(name), this, dataId);
        if (updateContentLength) {
            this.getContentLength(data);
        }
        return data;
    }

    public DataBean createDataBean(String name, File contentFile) throws MicroarrayException {
        try {
            DataBean bean = this.createDataBean(name);
            this.addContentLocationForDataBean(bean, StorageMethod.LOCAL_ORIGINAL, contentFile.toURI().toURL());
            return bean;
        }
        catch (ContentLengthException | IOException e) {
            throw new MicroarrayException(e);
        }
    }

    public DataBean createDataBean(String name, URL url) throws MicroarrayException, ContentLengthException, IOException {
        DataBean bean = this.createDataBean(name);
        this.addContentLocationForDataBean(bean, StorageMethod.REMOTE_ORIGINAL, url);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBean createDataBean(String name, InputStream content) throws MicroarrayException, IOException {
        File contentFile = this.createNewRepositoryFile(name);
        BufferedInputStream input = new BufferedInputStream(content);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(contentFile));
        try {
            IO.copy((InputStream)input, (OutputStream)output);
            ((OutputStream)output).flush();
        }
        finally {
            IOUtils.closeIfPossible(input);
            IOUtils.closeIfPossible(output);
        }
        DataBean bean = this.createDataBean(name);
        try {
            this.addContentLocationForDataBean(bean, StorageMethod.LOCAL_TEMP, contentFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new MicroarrayException(e);
        }
        catch (ContentLengthException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return bean;
    }

    public void delete(DataItem data) {
        if (data instanceof DataFolder) {
            this.deleteDataFolder((DataFolder)data);
        } else {
            this.deleteDataBean((DataBean)data);
        }
    }

    public void deleteAllDataItems() {
        this.deleteDataFolder(this.getRootFolder());
    }

    private void deleteDataBean(DataBean bean) {
        for (DataBean source : this.databeans()) {
            OperationRecord operationRecord = source.getOperationRecord();
            if (operationRecord == null) continue;
            operationRecord.removeInput(bean);
        }
        for (DataBean.Link linkType : DataBean.Link.values()) {
            for (DataBean target : bean.getLinkTargets(linkType)) {
                bean.removeLink(linkType, target);
            }
            for (DataBean source : bean.getLinkSources(linkType)) {
                source.removeLink(linkType, bean);
            }
        }
        DataFolder folder = bean.getParent();
        if (folder != null) {
            this.disconnectChild(bean, folder);
        }
        bean.delete();
    }

    public List<DataBean> databeans() {
        LinkedList<DataBean> databeans = new LinkedList<DataBean>();
        for (DataFolder folder : this.folders()) {
            for (DataItem child : folder.getChildren()) {
                if (!(child instanceof DataBean)) continue;
                databeans.add((DataBean)child);
            }
        }
        return databeans;
    }

    public List<DataFolder> folders() {
        return this.folders(this.getRootFolder());
    }

    public List<DataFolder> folders(DataFolder parent) {
        LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
        folders.add(parent);
        for (DataItem child : parent.getChildren()) {
            if (!(child instanceof DataFolder)) continue;
            folders.addAll(this.folders((DataFolder)child));
        }
        return folders;
    }

    public ChecksumInputStream getContentStream(DataBean bean, DataBean.DataNotAvailableHandling naHandling) throws IOException {
        InputStream baseStream = this.getBaseContentStream(bean, naHandling);
        if (baseStream instanceof ChecksumInputStream) {
            return (ChecksumInputStream)baseStream;
        }
        if (baseStream == null) {
            return null;
        }
        return new ChecksumInputStream(baseStream, false);
    }

    private InputStream getBaseContentStream(DataBean bean, DataBean.DataNotAvailableHandling naHandling) throws IOException {
        ContentLocation location = this.getClosestContentLocation(bean);
        if (location != null) {
            return location.getHandler().getInputStream(location);
        }
        try {
            return Session.getSession().getServiceAccessor().getFileBrokerClient().getInputStream(bean.getId());
        }
        catch (Exception e) {
            Exception remoteException = e;
            switch (naHandling) {
                case EMPTY_ON_NA: {
                    return new ByteArrayInputStream(new byte[0]);
                }
                case INFOTEXT_ON_NA: {
                    return new ByteArrayInputStream(DATA_NA_INFOTEXT.getBytes());
                }
                case NULL_ON_NA: {
                    return null;
                }
            }
            String message = "data contents not available";
            if (remoteException != null) {
                message = message + ": " + remoteException.getMessage();
            }
            throw new RuntimeException(message, remoteException);
        }
    }

    public byte[] getContentBytes(DataBean bean, DataBean.DataNotAvailableHandling naHandling) throws IOException {
        return this.getContentBytes(bean, -1L, naHandling);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentBytes(DataBean bean, long maxLength, DataBean.DataNotAvailableHandling naHandling) throws IOException {
        ChecksumInputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                in = this.getContentStream(bean, naHandling);
                if (in == null) break block3;
                byArray = Files.inputStreamToBytes(in, maxLength);
            }
            catch (Throwable throwable) {
                IOUtils.closeIfPossible(in);
                throw throwable;
            }
            IOUtils.closeIfPossible(in);
            return byArray;
        }
        byte[] byArray = null;
        IOUtils.closeIfPossible(in);
        return byArray;
    }

    public OutputStream getContentOutputStreamAndLockDataBean(DataBean bean) throws IOException {
        ContentLocation tempLocalLocation = bean.getContentLocation(StorageMethod.LOCAL_TEMP);
        if (tempLocalLocation == null) {
            this.convertToLocalTempDataBean(bean);
            tempLocalLocation = bean.getContentLocation(StorageMethod.LOCAL_TEMP);
        }
        block0: while (bean.getContentLocations().size() > 1) {
            for (ContentLocation location : bean.getContentLocations()) {
                if (location == tempLocalLocation) continue;
                bean.removeContentLocation(location);
                continue block0;
            }
        }
        bean.setId(CryptoKey.generateRandom());
        bean.setChecksum(null);
        bean.setSize(null);
        return tempLocalLocation.getHandler().getOutputStream(tempLocalLocation);
    }

    public void closeContentOutputStreamAndUnlockDataBean(DataBean bean, OutputStream out) throws MicroarrayException, IOException {
        out.close();
        ContentChangedEvent cce = new ContentChangedEvent(bean);
        this.dispatchEventIfVisible(cce);
    }

    public File getLocalFile(DataBean bean) throws IOException {
        ContentLocation location = bean.getContentLocation(StorageMethod.LOCAL_FILE_METHODS);
        if (location == null) {
            this.convertToLocalTempDataBean(bean);
            location = bean.getContentLocation(StorageMethod.LOCAL_FILE_METHODS);
        }
        LocalFileContentHandler handler = (LocalFileContentHandler)location.getHandler();
        return handler.getFile(location);
    }

    public File getLocalRandomAccessFile(DataBean bean) throws IOException {
        ContentLocation location = this.getClosestRandomAccessContentLocation(bean);
        if (location == null || !location.getMethod().isLocal()) {
            this.convertToLocalTempDataBean(bean);
        }
        location = this.getClosestRandomAccessContentLocation(bean);
        LocalFileContentHandler handler = (LocalFileContentHandler)location.getHandler();
        return handler.getFile(location);
    }

    public Long getContentLength(DataBean bean) {
        block5: {
            if (bean.getSize() == null) {
                try {
                    ContentLocation location = this.getClosestContentLocation(bean);
                    if (location != null) {
                        bean.setSize(this.getContentLength(location));
                        break block5;
                    }
                    Long size = Session.getSession().getServiceAccessor().getFileBrokerClient().getContentLength(bean.getId());
                    if (size != null) {
                        bean.setSize(size);
                        break block5;
                    }
                    return -1L;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return bean.getSize();
    }

    public Long getContentLength(ContentLocation location) throws IOException {
        return location.getHandler().getContentLength(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToLocalTempDataBean(DataBean bean) throws IOException {
        try {
            File newFile = this.createNewRepositoryFile(bean.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            ChecksumInputStream inputStream = this.getContentStream(bean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            try {
                IOUtils.copy((InputStream)in, out);
                this.setOrVerifyChecksum(bean, inputStream.verifyChecksums());
            }
            finally {
                IOUtils.closeIfPossible(in);
                IOUtils.closeIfPossible(out);
            }
            URL newURL = newFile.toURI().toURL();
            this.addContentLocationForDataBean(bean, StorageMethod.LOCAL_TEMP, newURL);
        }
        catch (ChecksumException | ContentLengthException e) {
            throw new IOException();
        }
    }

    private void deleteDataFolder(DataFolder folder) {
        Iterable<DataItem> children = folder.getChildren();
        LinkedList<DataItem> childrenToBeRemoved = new LinkedList<DataItem>();
        for (DataItem item : children) {
            childrenToBeRemoved.add(item);
        }
        for (DataItem item : childrenToBeRemoved) {
            this.delete(item);
        }
        DataFolder parent = folder.getParent();
        if (parent != null) {
            this.disconnectChild(folder, parent);
        }
    }

    private String getNamePostfix(String featureName, String factoryName) {
        if (factoryName.length() > featureName.length()) {
            return "";
        }
        String npf = featureName.substring(factoryName.length());
        if (npf.startsWith("/")) {
            return npf.substring(1);
        }
        return npf;
    }

    public Iterable<File> listAllRepositories() {
        LinkedList<File> repositories = new LinkedList<File>();
        File tempRoot = this.getTempRoot();
        for (File file : tempRoot.listFiles()) {
            String postfix;
            if (!file.isDirectory() || !file.getName().startsWith(TEMP_DIR_PREFIX) || !"".equals(postfix = file.getName().substring(TEMP_DIR_PREFIX.length())) && !Strings.isIntegerNumber(postfix)) continue;
            repositories.add(file);
        }
        return repositories;
    }

    public void flushSession() {
        this.zipContentHandler.closeZipFiles();
    }

    public void setModules(LinkedList<Module> modules) {
        this.modules = modules;
    }

    public void connectChildren(final List<? extends DataItem> children, final DataFolder parent) {
        final ArrayList callables = new ArrayList();
        final ArrayList events = new ArrayList();
        ThreadUtils.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (DataItem child : children) {
                    boolean wasConnected;
                    boolean bl = wasConnected = child.getParent() != null;
                    if (!wasConnected) {
                        events.add(new DataItemCreatedEvent(child));
                    }
                    child.setParent(parent);
                    parent.children.add(child);
                    if (!(child instanceof DataBean)) continue;
                    callables.add(new AddTypeTagsCallable((DataBean)child));
                }
            }
        });
        try {
            List futures = this.executor.invokeAll(callables);
            for (Future future : futures) {
                future.get();
            }
            ThreadUtils.runInEDT(new Runnable(){

                @Override
                public void run() {
                    for (DataItemCreatedEvent event : events) {
                        DataManager.this.dispatchEvent(event);
                    }
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            Session.getSession().getApplication().reportExceptionThreadSafely(e);
        }
    }

    public void connectChild(DataItem child, DataFolder parent) {
        ArrayList<DataItem> list = new ArrayList<DataItem>();
        list.add(child);
        this.connectChildren(list, parent);
    }

    public void disconnectChild(DataItem child, DataFolder parent) {
        child.setParent(null);
        parent.children.remove(child);
        this.dispatchEvent(new DataItemRemovedEvent(child));
    }

    public void addTypeTagsOfEachModule(DataBean data) throws IOException {
        if (!data.isTagsSet()) {
            for (Module module : this.modules) {
                try {
                    module.addTypeTags(data);
                }
                catch (MicroarrayException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        data.setTagsSet(true);
    }

    private ContentHandler getHandlerFor(StorageMethod method) {
        switch (method) {
            case LOCAL_SESSION_ZIP: {
                return this.zipContentHandler;
            }
            case LOCAL_TEMP: 
            case LOCAL_ORIGINAL: {
                return this.localFileContentHandler;
            }
            case REMOTE_ORIGINAL: {
                return this.remoteContentHandler;
            }
        }
        throw new IllegalArgumentException("unrecognised method: " + (Object)((Object)method));
    }

    public void addContentLocationForDataBean(DataBean bean, StorageMethod method, URL url) throws ContentLengthException, IOException {
        ContentLocation location = new ContentLocation(method, this.getHandlerFor(method), url);
        try {
            this.setOrVerifyContentLength(bean, this.getContentLength(location));
        }
        catch (IOException e) {
            throw new IOException("content length not available: " + e);
        }
        catch (ContentLengthException e) {
            try {
                DataManager manager = Session.getSession().getDataManager();
                String msg = "Wrong content length for dataset " + bean.getName() + ".  In ContentLocation " + location.getUrl() + ", length is " + this.getContentLength(location) + " bytes. ";
                msg = msg + "Content locations: ";
                for (ContentLocation loc : manager.getContentLocationsForDataBeanSaving(bean)) {
                    msg = msg + loc.getUrl() + " " + manager.getContentLength(loc) + " bytes, ";
                }
                throw new ContentLengthException(msg);
            }
            catch (IOException e1) {
                logger.error((Object)("another exception while handling " + Exceptions.getStackTrace(e)), (Throwable)e);
            }
        }
        bean.addContentLocation(location);
    }

    public void removeContentLocationsFromDataBean(DataBean bean, StorageMethod method) {
        bean.removeContentLocations(method);
    }

    public List<ContentLocation> getContentLocationsForDataBeanSaving(DataBean bean) {
        return bean.getContentLocations();
    }

    public boolean uploadToStorageIfNeeded(DataBean bean) throws Exception {
        if (Session.getSession().getServiceAccessor().getFileBrokerClient().isAvailable(bean.getId(), bean.getSize(), bean.getChecksum(), FileBrokerClient.FileBrokerArea.STORAGE)) {
            return true;
        }
        if (Session.getSession().getServiceAccessor().getFileBrokerClient().moveFromCacheToStorage(bean.getId())) {
            return true;
        }
        return this.upload(bean, FileBrokerClient.FileBrokerArea.STORAGE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadToCacheIfNeeded(DataBean bean, IOUtils.CopyProgressListener progressListener) throws NotEnoughDiskSpaceException, FileBrokerException, JMSException, IOException, Exception {
        try {
            bean.getLock().readLock().lock();
            if (Session.getSession().getServiceAccessor().getFileBrokerClient().isAvailable(bean.getId(), bean.getSize(), bean.getChecksum(), FileBrokerClient.FileBrokerArea.CACHE) || Session.getSession().getServiceAccessor().getFileBrokerClient().isAvailable(bean.getId(), bean.getSize(), bean.getChecksum(), FileBrokerClient.FileBrokerArea.STORAGE)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.upload(bean, FileBrokerClient.FileBrokerArea.CACHE, progressListener);
            return bl;
        }
        finally {
            bean.getLock().readLock().unlock();
        }
    }

    private boolean upload(DataBean dataBean, FileBrokerClient.FileBrokerArea area, IOUtils.CopyProgressListener progressListener) throws Exception {
        if (dataBean.getContentLocations().size() == 0) {
            return false;
        }
        try {
            String checksum = Session.getSession().getServiceAccessor().getFileBrokerClient().addFile(dataBean.getId(), area, this.getContentStream(dataBean, DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA), this.getContentLength(dataBean), progressListener);
            this.setOrVerifyChecksum(dataBean, checksum);
        }
        catch (Exception e) {
            logger.warn((Object)("could not upload data: " + dataBean.getName()), (Throwable)e);
            throw e;
        }
        return true;
    }

    public void setOrVerifyChecksum(DataBean dataBean, String checksum) throws ChecksumException {
        if (checksum != null) {
            if (dataBean.getChecksum() == null) {
                dataBean.setChecksum(checksum);
            } else if (!checksum.equals(dataBean.getChecksum())) {
                throw new ChecksumException();
            }
        }
    }

    public void setOrVerifyContentLength(DataBean dataBean, Long contentLength) throws ContentLengthException {
        if (contentLength != null) {
            if (dataBean.getSize() == null) {
                dataBean.setSize(contentLength);
            } else if (!contentLength.equals(dataBean.getSize())) {
                throw new ContentLengthException();
            }
        }
    }

    public ContentLocation getClosestRandomAccessContentLocation(DataBean bean) {
        List<ContentLocation> closestContentLocations = this.getClosestContentLocationList(bean);
        for (ContentLocation contentLocation : closestContentLocations) {
            if (contentLocation == null || !contentLocation.method.isRandomAccess() || !this.isAccessible(contentLocation)) continue;
            return contentLocation;
        }
        return null;
    }

    private ContentLocation getClosestContentLocation(DataBean bean) {
        List<ContentLocation> closestContentLocations = this.getClosestContentLocationList(bean);
        for (ContentLocation contentLocation : closestContentLocations) {
            if (contentLocation == null || !this.isAccessible(contentLocation)) continue;
            return contentLocation;
        }
        return null;
    }

    private List<ContentLocation> getClosestContentLocationList(DataBean bean) {
        LinkedList<ContentLocation> closestLocations = new LinkedList<ContentLocation>();
        closestLocations.addAll(bean.getContentLocations(StorageMethod.LOCAL_FILE_METHODS));
        closestLocations.addAll(bean.getContentLocations(StorageMethod.REMOTE_FILE_METHODS));
        closestLocations.addAll(bean.getContentLocations(StorageMethod.OTHER_SLOW_METHODS));
        return closestLocations;
    }

    private boolean isAccessible(ContentLocation location) {
        return location.getHandler().isAccessible(location);
    }

    public Long getFastRowCount(DataBean data) throws MicroarrayException {
        if (this.getContentLength(data) < 102400L && (data.hasTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES) || data.hasTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES) || data.hasTypeTag(MicroarrayModule.TypeTags.PHENODATA))) {
            Long cachedCount = (Long)data.getFromContentBoundCache(AT_LEAST_ROWS_CACHENAME);
            if (cachedCount != null) {
                return cachedCount;
            }
            try (Table rowCounter = data.queryFeatures("/column/*").asTable();){
                long rowCount;
                for (rowCount = 0L; rowCounter != null && rowCounter.nextRow() && rowCount < 1000L; ++rowCount) {
                }
                data.putToContentBoundCache(AT_LEAST_ROWS_CACHENAME, rowCount);
                Long l = rowCount;
                return l;
            }
        }
        return null;
    }

    public class AddTypeTagsCallable
    implements Callable<Object> {
        private DataBean child;

        public AddTypeTagsCallable(DataBean child) {
            this.child = child;
        }

        @Override
        public Object call() throws Exception {
            DataManager.this.addTypeTagsOfEachModule(this.child);
            return null;
        }
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String validationDetails) {
        }
    }

    public static enum StorageMethod {
        LOCAL_ORIGINAL(true, true),
        LOCAL_TEMP(true, true),
        LOCAL_SESSION_ZIP(true, false),
        REMOTE_ORIGINAL(false, true);

        public static StorageMethod[] LOCAL_FILE_METHODS;
        public static StorageMethod[] REMOTE_FILE_METHODS;
        public static StorageMethod[] OTHER_SLOW_METHODS;
        private boolean isLocal;
        private boolean isRandomAccess;

        private StorageMethod(boolean isLocal, boolean isRandomAccess) {
            this.isLocal = isLocal;
            this.isRandomAccess = isRandomAccess;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isRandomAccess() {
            return this.isRandomAccess;
        }

        public static StorageMethod valueOfConverted(String name) {
            if ("REMOTE_STORAGE".equals(name)) {
                name = "REMOTE_ORIGINAL";
            } else if ("LOCAL_USER".equals(name)) {
                name = "LOCAL_ORIGINAL";
            } else if ("LOCAL_SESSION".equals(name)) {
                name = "LOCAL_SESSION_ZIP";
            }
            return StorageMethod.valueOf(name);
        }

        static {
            LOCAL_FILE_METHODS = new StorageMethod[]{LOCAL_ORIGINAL, LOCAL_TEMP};
            REMOTE_FILE_METHODS = new StorageMethod[]{REMOTE_ORIGINAL};
            OTHER_SLOW_METHODS = new StorageMethod[]{LOCAL_SESSION_ZIP};
        }
    }

    public static class ContentLocation {
        StorageMethod method;
        URL url;
        private ContentHandler handler;

        public ContentLocation(StorageMethod method, ContentHandler handler, URL url) {
            this.method = method;
            this.handler = handler;
            this.url = url;
        }

        public StorageMethod getMethod() {
            return this.method;
        }

        public URL getUrl() {
            return this.url;
        }

        public ContentHandler getHandler() {
            return this.handler;
        }
    }
}

