/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.selection.SelectionEvent;
import fi.csc.microarray.client.visualisation.methods.threed.AutomatedMovement;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.Projection;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.concurrent.PriorityBlockingQueue;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

public class CoordinateArea
extends JComponent
implements ActionListener,
MouseInputListener,
MouseWheelListener,
PropertyChangeListener {
    private static final double KINETIC_SPEED_FACTOR = 0.002;
    private static long MOVE_TIME_LIMIT = 10L;
    private JMenuItem hideSelected;
    private JMenuItem showAll;
    private JMenuItem invertSelection;
    private JMenuItem saveAs;
    public PaintMode paintMode = PaintMode.SPHERE;
    private boolean kineticMoveMode = false;
    private LinkedList<DataPoint> selectedPoints;
    private Projection projection;
    protected AutomatedMovement movement;
    private ClientApplication application = Session.getSession().getApplication();
    Scatterplot3D controller;
    final double ANGLE_INCREMENT = 0.002181661564992912;
    private AutomatedMovement.RotationTask kineticMovement;
    private long lastDragEventTime = -1L;
    private int mousePressX = 0;
    private int mousePressY = 0;
    private int mouseX;
    private int mouseY;
    boolean mouseDragged = false;

    public PaintMode getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(PaintMode mode) {
        this.paintMode = mode;
        this.repaint();
    }

    public CoordinateArea(Scatterplot3D controller) {
        this.controller = controller;
        this.createPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setOpaque(true);
        this.setFocusable(true);
        this.setBackground(Color.black);
        this.selectedPoints = new LinkedList();
        this.projection = new Projection(controller.getDataModel());
        this.movement = new AutomatedMovement(this.projection, this);
        this.movement.start();
        this.kineticMovement = this.movement.startKineticMove(25.0, 0.95);
        this.updateSelectedFromApplication();
        this.application.addClientEventListener(this);
    }

    public Projection getProjection() {
        return this.projection;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getHeight() <= this.getWidth()) {
            this.projection.setViewWindowWidth(this.projection.getViewWindowHeight() * (double)this.getWidth() / (double)this.getHeight());
        } else {
            this.projection.setViewWindowHeight(this.projection.getViewWindowWidth() * (double)this.getHeight() / (double)this.getWidth());
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PriorityBlockingQueue<Drawable> points = this.projection.doProjection();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        Drawable p = null;
        while ((p = points.poll()) != null) {
            p.draw(g2d, this.getWidth(), this.getHeight(), this.getPaintMode());
        }
        if (this.mouseDragged) {
            g2d.setColor(Color.WHITE);
            g2d.setStroke(VisualConstants.dashLine);
            int x = this.mousePressX < this.mouseX ? this.mousePressX : this.mouseX;
            int y = this.mousePressY < this.mouseY ? this.mousePressY : this.mouseY;
            int w = Math.abs(this.mouseX - this.mousePressX);
            int h = Math.abs(this.mouseY - this.mousePressY);
            g2d.setColor(this.getForeground());
            g2d.drawRect(x, y, w, h);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                if (e.isControlDown()) {
                    this.addToSelections(e);
                    break;
                }
                this.selectOne(e);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.repaint();
    }

    public void rotateWithDrag(int mouseX, int mouseY, MouseEvent e) {
        double xfactor = Math.abs(mouseX - this.mousePressX);
        double yfactor = Math.abs(mouseY - this.mousePressY);
        this.controller.stopAutoRotation();
        if (e.isShiftDown()) {
            double deg = this.projection.getZAxisRotation();
            if (this.mousePressX - mouseX < 0) {
                this.projection.setZAxisRotation(deg + 0.002181661564992912 * xfactor);
            } else if (this.mousePressX - mouseX > 0) {
                this.projection.setZAxisRotation(deg - 0.002181661564992912 * xfactor);
            }
            this.zoom((double)(mouseY - this.mousePressY) / 100.0);
        } else if (!this.kineticMoveMode) {
            this.kineticMovement.stop();
            double deg = this.projection.getYAxisRotation();
            if (this.mousePressX - mouseX < 0) {
                this.projection.setYAxisRotation(deg + 0.002181661564992912 * xfactor);
            } else if (this.mousePressX - mouseX > 0) {
                this.projection.setYAxisRotation(deg - 0.002181661564992912 * xfactor);
            }
            deg = this.projection.getXAxisRotation();
            if (this.mousePressY - mouseY < 0) {
                this.projection.setXAxisRotation(deg + 0.002181661564992912 * yfactor);
            } else if (this.mousePressY - mouseY > 0) {
                this.projection.setXAxisRotation(deg - 0.002181661564992912 * yfactor);
            }
            this.kineticMovement.setAngleIncs(0.002 * (double)(mouseY - this.mousePressY), 0.002 * (double)(mouseX - this.mousePressX), 0.0);
        }
        this.mousePressX = mouseX;
        this.mousePressY = mouseY;
        this.lastDragEventTime = System.currentTimeMillis();
        if (!this.kineticMoveMode) {
            this.repaint();
        }
    }

    public void moveWithDrag(int mouseX, int mouseY, MouseEvent e) {
        double[] orig = this.projection.getPointOfView();
        double divider = this.projection.getDistanceOfProjectionPlaneFromOrigin() * this.projection.getDistanceOfProjectionPlaneFromOrigin();
        orig[0] = orig[0] - (double)(mouseX - this.mousePressX) / divider;
        orig[1] = orig[1] - (double)(mouseY - this.mousePressY) / divider;
        this.projection.setPointOfView(orig);
        this.mousePressX = mouseX;
        this.mousePressY = mouseY;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.kineticMovement.stop();
        this.mousePressX = e.getX();
        this.mousePressY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.controller.getTool() == Scatterplot3D.Tool.ROTATE) {
            this.rotateWithDrag(e.getX(), e.getY(), e);
        } else if (this.controller.getTool() == Scatterplot3D.Tool.MOVE) {
            this.moveWithDrag(e.getX(), e.getY(), e);
        } else if (this.controller.getTool() == Scatterplot3D.Tool.SELECT) {
            this.mouseDragged = true;
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (System.currentTimeMillis() - this.lastDragEventTime < MOVE_TIME_LIMIT) {
            this.kineticMovement = this.movement.restartKineticMove();
        } else {
            this.kineticMovement.stop();
        }
        if (e.getButton() == 1 && this.mouseDragged) {
            this.selectGroup(e, this.mousePressX, this.mousePressY);
            this.mouseDragged = false;
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoom((double)e.getWheelRotation() / 10.0);
    }

    private void zoom(double value) {
        double[] pov = this.projection.getPointOfView();
        pov[2] = pov[2] - value;
        this.projection.setPointOfView(pov);
        this.repaint();
    }

    private void clearSelections() {
        if (this.selectedPoints == null) {
            return;
        }
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = false;
        }
        this.selectedPoints.clear();
        this.controller.getAnnotateList().setSelectedListContentAsDataPoints(this.selectedPoints, this, false, this.controller.getFrame().getDatas().get(0));
    }

    private void selectOne(MouseEvent e) {
        this.clearSelections();
        this.selectedPoints = DataPoint.getNearest(e.getX(), e.getY(), this.controller.getDataModel().getDataArray(), 8.0);
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = true;
        }
        this.controller.getAnnotateList().setSelectedListContentAsDataPoints(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    private void addToSelections(MouseEvent e) {
        LinkedList<DataPoint> newSelection = DataPoint.getNearest(e.getX(), e.getY(), this.controller.getDataModel().getDataArray(), 4.0);
        for (DataPoint dp : newSelection) {
            if (dp == null) continue;
            if (dp.selected) {
                dp.selected = false;
                this.selectedPoints.remove(dp);
                continue;
            }
            dp.selected = true;
            this.selectedPoints.add(dp);
        }
        this.controller.getAnnotateList().setSelectedListContentAsDataPoints(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    private void selectGroup(MouseEvent e, int x1, int y1) {
        this.clearSelections();
        this.selectedPoints = DataPoint.getGroup(x1, y1, e.getX(), e.getY(), this.controller.getDataModel().getDataArray());
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = true;
        }
        this.controller.getAnnotateList().setSelectedListContentAsDataPoints(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hideSelected) {
            for (Drawable drawable : this.selectedPoints) {
                drawable.hidden = true;
            }
        } else if (e.getSource() == this.showAll) {
            for (Drawable d : this.controller.getDataModel().getDataArray()) {
                d.hidden = false;
            }
        } else if (e.getSource() == this.invertSelection) {
            this.selectedPoints = new LinkedList();
            for (Drawable d : this.controller.getDataModel().getDataArray()) {
                boolean bl = d.selected = !d.selected;
                if (!(d instanceof DataPoint) || !d.selected) continue;
                this.selectedPoints.add((DataPoint)d);
            }
        } else if (e.getSource() == this.saveAs) {
            this.controller.saveAs();
        }
        this.repaint();
    }

    public void createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.hideSelected = new JMenuItem("Hide selected");
        this.hideSelected.addActionListener(this);
        popup.add(this.hideSelected);
        this.showAll = new JMenuItem("Show all points");
        this.showAll.addActionListener(this);
        popup.add(this.showAll);
        this.invertSelection = new JMenuItem("Invert selection");
        this.invertSelection.addActionListener(this);
        popup.add(this.invertSelection);
        this.saveAs = new JMenuItem("Save as...");
        this.saveAs.addActionListener(this);
        popup.add(this.saveAs);
        PopupListener popupListener = new PopupListener(popup);
        this.addMouseListener(popupListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof SelectionEvent && !evt.getSource().equals(this) && ((SelectionEvent)evt).getData() == this.controller.getFrame().getDatas().get(0)) {
            this.updateSelectedFromApplication();
            this.repaint();
        }
    }

    private void updateSelectedFromApplication() {
        Drawable[] drawables = this.controller.getDataModel().getDataArray();
        this.clearSelections();
        block0: for (int index : this.application.getSelectionManager().getSelectionManager(this.controller.getFrame().getDatas().get(0)).getSelectionAsRows()) {
            for (Drawable drawable : drawables) {
                DataPoint dp;
                if (!(drawable instanceof DataPoint) || (dp = (DataPoint)drawable).getIndex() != index) continue;
                dp.selected = true;
                this.selectedPoints.add(dp);
                continue block0;
            }
        }
        this.controller.getAnnotateList().setSelectedListContentAsDataPoints(this.selectedPoints, this, false, this.controller.getFrame().getDatas().get(0));
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int y = e.getY();
                if (CoordinateArea.this.selectedPoints.isEmpty()) {
                    CoordinateArea.this.hideSelected.setEnabled(false);
                    CoordinateArea.this.invertSelection.setEnabled(false);
                    CoordinateArea.this.showAll.setEnabled(false);
                } else {
                    CoordinateArea.this.hideSelected.setEnabled(true);
                    CoordinateArea.this.invertSelection.setEnabled(true);
                    CoordinateArea.this.showAll.setEnabled(true);
                }
                this.popup.show(e.getComponent(), x, y);
            }
        }
    }

    public static enum PaintMode {
        SPHERE("Sphere"),
        RECT("Rectangle");

        private String name;

        private PaintMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

