/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;

public class BpCoord
implements Comparable<BpCoord> {
    private static final BpCoord MAX = new BpCoord(Long.MAX_VALUE, null);
    private static final BpCoord MIN = new BpCoord(0L, null);
    public Long bp;
    public Chromosome chr;

    public BpCoord(Long bp, Chromosome chr) {
        this.bp = bp;
        this.chr = chr;
    }

    public BpCoord(BpCoord o) {
        this(new Long(o.bp), new Chromosome(o.chr));
    }

    public BpCoord clone() {
        return new BpCoord(this.bp, this.chr.clone());
    }

    @Override
    public int compareTo(BpCoord o) {
        int chrComparison = this.chr.compareTo(o.chr);
        if (chrComparison != 0) {
            return chrComparison;
        }
        return this.bp.compareTo(o.bp);
    }

    @Override
    public int compareTo(Long o) {
        return this.bp.compareTo(o);
    }

    public boolean equals(Object o) {
        if (o instanceof BpCoord) {
            BpCoord other = (BpCoord)o;
            return this.chr.equals(other.chr) && this.bp.equals(other.bp);
        }
        return false;
    }

    public int hashCode() {
        return this.bp.hashCode();
    }

    public Long minus(BpCoord o) {
        if (this.chr.equals(o.chr)) {
            return this.bp - o.bp;
        }
        return null;
    }

    public Long plus(BpCoord o) {
        if (this.chr.equals(o.chr)) {
            return this.bp + o.bp;
        }
        return null;
    }

    public String toString() {
        return "Bp: " + this.bp + ", Chr: " + this.chr;
    }

    public BpCoord max(BpCoord other) {
        return this.compareTo(other) < 0 ? other : this;
    }

    public BpCoord min(BpCoord other) {
        return this.compareTo(other) > 0 ? other : this;
    }

    public static BpCoord getMax() {
        return MAX.clone();
    }

    public static BpCoord getMin() {
        return MIN.clone();
    }
}

