/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutChild;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutParent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutUpdater;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ScrollGroup
implements LayoutChild,
LayoutParent {
    private JScrollPane component = new JScrollPane(){

        @Override
        public Dimension getMinimumSize() {
            Dimension pref = super.getPreferredSize();
            if (pref.getHeight() < 250.0) {
                return pref;
            }
            return new Dimension((int)pref.getWidth(), 250);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension pref = ScrollGroup.this.canvas.getPreferredSize();
            Dimension max = super.getMaximumSize();
            if (LayoutTool.LayoutMode.FILL == ScrollGroup.this.getLayoutMode()) {
                return max;
            }
            return pref;
        }
    };
    public List<TrackGroup> trackGroups = new LinkedList<TrackGroup>();
    private JPanel canvas = new JPanel();
    private String name;
    private boolean scrollEnabled = false;
    private GBrowserView view;

    public ScrollGroup() {
        this.component.setViewportView(this.canvas);
        this.component.getVerticalScrollBar().setUnitIncrement(10);
        this.component.setBorder(null);
        this.canvas.setLayout((LayoutManager)new MigLayout("flowy, fillx, gap 0! 0!, insets 0"));
        this.component.setInheritsPopupMenu(true);
        this.canvas.setInheritsPopupMenu(true);
        this.component.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ScrollGroup.this.view != null) {
                    ScrollGroup.this.view.getComponent().repaint();
                }
            }
        });
    }

    public ScrollGroup(String name) {
        this();
        this.name = name;
    }

    public ScrollGroup(String name, boolean scrollEnabled) {
        this(name);
        this.scrollEnabled = scrollEnabled;
    }

    public void addTrack(Track track) {
        this.addTrackGroup(new TrackGroup(track));
    }

    public void addTrackGroup(TrackGroup group) {
        this.trackGroups.add(group);
        group.setScrollGroup(this);
        this.updateLayout();
    }

    public Collection<TrackGroup> getTrackGroups() {
        return this.trackGroups;
    }

    public String toString() {
        return ScrollGroup.class + " " + this.name;
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    public int getScrollReferenceY() {
        return 0;
    }

    public String getScrollGroupName() {
        return this.name;
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        LayoutTool.LayoutMode inferedMode = LayoutTool.inferScrollGroupLayoutMode(this.trackGroups);
        return inferedMode;
    }

    public void setScrollEnabled(boolean enabled) {
        this.scrollEnabled = enabled;
    }

    @Override
    public void updateLayout() {
        new LayoutUpdater<TrackGroup, ScrollGroup>().update(this.trackGroups, this);
        this.canvas.revalidate();
    }

    public Container getCanvas() {
        return this.canvas;
    }

    @Override
    public JScrollPane getLayoutComponent() {
        return this.component;
    }

    public GBrowserView getView() {
        return this.view;
    }

    public void setView(GBrowserView view) {
        this.view = view;
    }

    @Override
    public JComponent getLayoutContainer() {
        return this.canvas;
    }
}

