/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class Task {
    private OperationRecord operationRecord;
    private String id;
    private State state = State.NEW;
    private String stateDetail = "";
    private int completionPercentage = -1;
    private Date startTime;
    private Date endTime;
    private String errorMessage;
    private String screenOutput;
    private ArrayList<DataBean> outputs = new ArrayList();
    private boolean hidden = false;
    private List<TaskEventListener> listeners = new LinkedList<TaskEventListener>();
    private boolean isLocal;

    public Task(OperationRecord operationRecord, boolean local) {
        this.operationRecord = operationRecord;
        this.id = this.generateId();
        this.isLocal = local;
    }

    public Task(OperationRecord operationRecord, String jobId, Date startTime, Date endTime, boolean local) {
        this.operationRecord = operationRecord;
        this.id = jobId;
        this.isLocal = local;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getOperationID() {
        return this.operationRecord.getNameID().getID();
    }

    public String getName() {
        return this.operationRecord.getNameID().getDisplayName();
    }

    public String getFullName() {
        return this.operationRecord.getCategoryName() + " / " + this.operationRecord.getNameID().getDisplayName();
    }

    public Collection<OperationRecord.InputRecord> getInputRecords() {
        return this.operationRecord.getInputRecords();
    }

    public Iterable<DataBean> getInputDataBeans() {
        return this.operationRecord.getInputDataBeans();
    }

    public List<String> getParameters() throws TaskException, MicroarrayException {
        LinkedList<String> parameterStrings = new LinkedList<String>();
        for (OperationRecord.ParameterRecord parameter : this.operationRecord.getParameters()) {
            parameterStrings.add(parameter.getValue());
        }
        return parameterStrings;
    }

    public int getInputCount() {
        return this.operationRecord.getInputRecords().size();
    }

    public void addOutput(DataBean bean) {
        this.outputs.add(bean);
    }

    public synchronized void setState(State newState) {
        this.state = newState;
        this.stateDetail = "";
    }

    public void notifyTaskStateChangeListener(State oldState, State newState) {
        TaskStateChangeNotifier changeNotifier = new TaskStateChangeNotifier(oldState, newState);
        ThreadUtils.runInEDT(changeNotifier);
    }

    public synchronized State getState() {
        return this.state;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<DataBean> getOutputs() {
        return this.outputs;
    }

    public String getScreenOutput() {
        return this.screenOutput;
    }

    public void setScreenOutput(String screenOutput) {
        this.screenOutput = screenOutput;
    }

    public String getStateDetail() {
        if (this.stateDetail != null) {
            return this.stateDetail;
        }
        return "";
    }

    public void setStateDetail(String stateDetail) {
        this.stateDetail = stateDetail;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void changeId() {
        this.id = this.generateId();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        if (this.operationRecord != null) {
            this.operationRecord.setStartTime(startTime);
        }
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        if (this.operationRecord != null) {
            this.operationRecord.setEndTime(endTime);
        }
    }

    public long getExecutionTime() {
        if (this.state.isFinished()) {
            if (this.startTime != null && this.endTime != null) {
                return this.endTime.getTime() - this.startTime.getTime();
            }
        } else if (this.startTime != null) {
            return System.currentTimeMillis() - this.startTime.getTime();
        }
        return -1L;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void addTaskEventListener(TaskEventListener listener) {
        this.listeners.add(listener);
    }

    public void setCompletionPercentage(int completionPercentage) {
        this.completionPercentage = completionPercentage;
    }

    public int getCompletionPercentage() {
        return this.completionPercentage;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public OperationRecord getOperationRecord() {
        return this.operationRecord;
    }

    private class TaskStateChangeNotifier
    implements Runnable {
        private State oldState;
        private State newState;

        public TaskStateChangeNotifier(State oldState, State newState) {
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        public void run() {
            for (TaskEventListener listener : Task.this.listeners) {
                listener.onStateChange(Task.this, this.oldState, this.newState);
            }
        }
    }

    public static enum State {
        NEW("New"),
        TRANSFERRING_INPUTS("Transferring inputs"),
        WAITING("Waiting"),
        RUNNING("Running"),
        TRANSFERRING_OUTPUTS("Transferring outputs"),
        COMPLETED("Completed"),
        FAILED("Failed"),
        FAILED_USER_ERROR("Failed, fixable"),
        ERROR("Error"),
        CANCELLED("Cancelled"),
        TIMEOUT("Timeout");

        private String description;

        private State(String description) {
            this.description = description;
        }

        public boolean isFinished() {
            return this.equals((Object)COMPLETED) || this.equals((Object)FAILED) || this.equals((Object)FAILED_USER_ERROR) || this.equals((Object)ERROR) || this.equals((Object)CANCELLED) || this.equals((Object)TIMEOUT);
        }

        public boolean finishedSuccesfully() {
            return this.equals((Object)COMPLETED);
        }

        public String toString() {
            return this.description;
        }
    }
}

