/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ColumnTypePattern;
import fi.csc.microarray.client.dataimport.DataColumn;
import fi.csc.microarray.client.dataimport.events.ChipCountChangeEvent;
import fi.csc.microarray.client.dataimport.events.ChipNumberChangedEvent;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangeListener;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangeSupport;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangedEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ColumnTypeManager
implements ColumnTypeChangeSupport {
    private static final Logger logger = Logger.getLogger(ColumnTypeManager.class);
    private List<DataColumn> columns;
    private int chipCount;
    private int columnCount;
    private List<DataColumn> columnsBeforePatternSelection;
    private List<ColumnTypeChangeListener> columnTypeListeners;

    public ColumnTypeManager(int columnCount) {
        this.columnCount = columnCount;
        this.chipCount = 0;
        this.columns = new ArrayList<DataColumn>();
        this.columnTypeListeners = new ArrayList<ColumnTypeChangeListener>();
        this.columnsBeforePatternSelection = new ArrayList<DataColumn>();
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
        int columnIndex = 0;
        while (this.columns.size() <= columnCount) {
            if (columnIndex == 0) {
                this.columns.add(DataColumn.createRowNumberColumn(columnIndex));
            }
            this.columns.add(DataColumn.createEmptyDataColumn(columnIndex));
            ++columnIndex;
        }
    }

    public void setChipCount(int chipCount) {
        this.chipCount = chipCount;
        this.fireChipCountChangeEvent(new ChipCountChangeEvent((Object)this, chipCount));
    }

    public int getCountOfType(ColumnType askedType) {
        int count = 0;
        for (DataColumn columnFromList : this.columns) {
            if (!columnFromList.getColumnType().equals((Object)askedType)) continue;
            ++count;
        }
        return count;
    }

    public List<String> getOriginalChipNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DataColumn column : this.columns) {
            if (!column.getColumnType().equals((Object)ColumnType.SAMPLE_LABEL)) continue;
            names.add(column.getOriginalName());
        }
        return names;
    }

    public void setColumnType(int columnIndex, ColumnType type, String originalName) {
        if (columnIndex == 0) {
            throw new IllegalArgumentException("Can't change the type of the first column");
        }
        if (ColumnType.ROW_NUMBER.equals((Object)type)) {
            throw new IllegalArgumentException("Can't change the column type to ROW_NUMBER");
        }
        this.columns.set(columnIndex, new DataColumn(type, -1, columnIndex, originalName));
        this.setChipCount(this.getCountOfType(ColumnType.SAMPLE_LABEL));
        this.fireColumnTypeChangeEvent(new ColumnTypeChangedEvent(this, type, columnIndex));
    }

    public void selectColumnsFromPattern(ColumnTypePattern pattern, boolean ignoreFirstUnusedColumns, String[] originalNames) {
        this.columnsBeforePatternSelection.clear();
        this.columnsBeforePatternSelection.addAll(this.getColumns());
        boolean firstUsedColumnFound = !ignoreFirstUnusedColumns;
        for (int columnNumber = 1; columnNumber < this.getColumnCount(); ++columnNumber) {
            ColumnType type;
            if (!this.getColumnType(columnNumber).equals((Object)ColumnType.UNUSED_LABEL)) {
                firstUsedColumnFound = true;
            }
            if (!firstUsedColumnFound || (type = pattern.getColumnTypeForIndex(columnNumber)) == null) continue;
            String title = originalNames != null && originalNames.length >= columnNumber ? originalNames[columnNumber] : null;
            this.setColumnType(columnNumber, type, title);
            this.setColumnChipNumber(columnNumber, this.getNextChipNumber(type));
        }
    }

    public void setColumns(List<DataColumn> newColumns) {
        for (int columnNumber = 0; columnNumber < this.getColumnCount(); ++columnNumber) {
            if (columnNumber == 0) continue;
            DataColumn column = newColumns.get(columnNumber);
            this.setColumnType(columnNumber, column.getColumnType(), column.getOriginalName());
            this.setColumnChipNumber(columnNumber, column.getChipNumber());
        }
    }

    public void undoPatternSelection() {
        if (this.columnsBeforePatternSelection.isEmpty()) {
            throw new IllegalArgumentException("Nothing to undo");
        }
        this.setColumns(this.columnsBeforePatternSelection);
        this.columnsBeforePatternSelection.clear();
    }

    public int getNextChipNumber(ColumnType type) {
        int i;
        ArrayList<Integer> chipNumbersInUse = new ArrayList<Integer>();
        for (i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getColumnType().equals((Object)type)) continue;
            chipNumbersInUse.add(this.columns.get(i).getChipNumber());
        }
        logger.debug((Object)("Count of chip numbers set to " + type.toString() + " is " + chipNumbersInUse.size()));
        for (i = 1; i < this.columnCount; ++i) {
            if (chipNumbersInUse.contains(i)) continue;
            return i;
        }
        return this.columnCount;
    }

    public ColumnType getColumnType(int columnIndex) {
        return this.columns.get(columnIndex).getColumnType();
    }

    public int getColumnChipNumber(int columnIndex) {
        return this.columns.get(columnIndex).getChipNumber();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getChipCount() {
        return this.chipCount;
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("ColumnTypeManager [column count: " + this.getColumnCount() + " UNUSED: " + this.getCountOfType(ColumnType.UNUSED_LABEL) + " IDENTIFIERS: " + this.getCountOfType(ColumnType.IDENTIFIER_LABEL) + " SAMPLES: " + this.getCountOfType(ColumnType.SAMPLE_LABEL) + "]");
        return string.toString();
    }

    public boolean isLessTypesSelectedThanChips(ColumnType type) {
        return this.getCountOfType(type) < this.getChipCount();
    }

    public boolean isAsManyTypesSelectedThanChips(ColumnType type) {
        return this.getCountOfType(type) == this.getChipCount();
    }

    public boolean isMoreTypesSelectedThanChips(ColumnType type) {
        return this.getCountOfType(type) > this.getChipCount();
    }

    public boolean isChipNumberSetProperly(int columnIndex) {
        if (this.getColumnType(columnIndex).equals((Object)ColumnType.UNUSED_LABEL)) {
            return true;
        }
        if (this.getColumnType(columnIndex).equals((Object)ColumnType.ANNOTATION_LABEL)) {
            return true;
        }
        int chip = this.getColumnChipNumber(columnIndex);
        return chip > 0 && chip <= this.getChipCount();
    }

    public int getCountOfCorrectlySet(ColumnType type) {
        int count = 0;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            ColumnType typeFromList = this.columns.get(columnIndex).getColumnType();
            if (typeFromList == null || !typeFromList.equals((Object)type) || !this.isChipNumberSetProperly(columnIndex)) continue;
            ++count;
        }
        return count;
    }

    public void setColumnChipNumber(int columnIndex, int chipNumber) {
        for (DataColumn column : this.getColumns()) {
            if (column.getColumnType() != this.getColumnType(columnIndex) || column.getChipNumber() != chipNumber || column.getColumnIndex() == columnIndex) continue;
            column.setChipNumber(-1);
            this.fireChipNumberChangeEvent(new ChipNumberChangedEvent(this, Integer.MAX_VALUE, column.getColumnIndex()));
        }
        this.columns.get(columnIndex).setChipNumber(chipNumber);
        this.fireChipNumberChangeEvent(new ChipNumberChangedEvent(this, chipNumber, columnIndex));
    }

    public List<DataColumn> getColumns() {
        return this.columns;
    }

    @Override
    public void addColumnTypeChangeListener(ColumnTypeChangeListener l) {
        this.columnTypeListeners.add(l);
    }

    @Override
    public void fireChipNumberChangeEvent(ChipNumberChangedEvent event) {
        for (ColumnTypeChangeListener listener : this.columnTypeListeners) {
            listener.chipNumberChanged(event);
        }
        logger.debug((Object)("Fired event " + event.toString()));
    }

    @Override
    public void fireColumnTypeChangeEvent(ColumnTypeChangedEvent event) {
        for (ColumnTypeChangeListener listener : this.columnTypeListeners) {
            listener.columnTypeChanged(event);
        }
        logger.debug((Object)("Fired event " + event.toString()));
    }

    @Override
    public void removeColumnTypeChangeListener(ColumnTypeChangeListener l) {
        this.columnTypeListeners.remove(l);
    }

    @Override
    public void fireChipCountChangeEvent(ChipCountChangeEvent event) {
        for (ColumnTypeChangeListener listener : this.columnTypeListeners) {
            listener.chipCountChanged(event);
        }
        logger.debug((Object)("Fired event " + event.toString()));
    }

    public void resetColumnTypes() {
        for (int columnIndex = 1; columnIndex < this.getColumnCount(); ++columnIndex) {
            this.setColumnType(columnIndex, ColumnType.UNUSED_LABEL, null);
        }
    }
}

