/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import fi.csc.chipster.toolbox.ToolboxService;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Node;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.messaging.message.SourceMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.JMSException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ToolboxServer
extends MonitoredNodeBase
implements MessagingListener,
ShutdownCallback {
    private Logger logger = LogManager.getLogger();
    private MessagingEndpoint endpoint;
    private ToolboxService toolboxRestService;

    public ToolboxServer(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("toolbox"), (String)configURL);
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.logger.info("starting toolbox service...");
        String url = configuration.getString("messaging", "toolbox-url");
        String toolsBinPath = configuration.getString("toolbox", "tools-bin-path");
        this.toolboxRestService = new ToolboxService(url, toolsBinPath);
        this.toolboxRestService.startServerWithoutStatsAndAdminServer();
        this.endpoint = new JMSMessagingEndpoint((Node)this);
        MessagingTopic compTopic = this.endpoint.createTopic(Topics.Name.TOOLBOX_TOPIC, MessagingTopic.AccessMode.READ);
        compTopic.setListener((MessagingListener)this);
        KeepAliveShutdownHandler.init((ShutdownCallback)this);
        this.logger.info("toolbox is up and running [" + ApplicationConstants.VERSION + "]");
        this.logger.info("[mem: " + SystemMonitorUtil.getMemInfo() + "]");
    }

    public void onChipsterMessage(ChipsterMessage chipsterMessage) {
        if (chipsterMessage instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)chipsterMessage;
            if ("describe".equals(commandMessage.getCommand())) {
                try {
                    this.handleGetDescriptions(commandMessage);
                }
                catch (Exception e) {
                    this.logger.error("sending descriptions messages failed", (Throwable)e);
                }
                return;
            }
            if ("get-source".equals(commandMessage.getCommand())) {
                this.handleGetSourceCode(commandMessage);
                return;
            }
            this.logger.warn("unexpected command message: " + commandMessage.getCommand());
        } else {
            this.logger.warn("expecting a command message, got something else: " + chipsterMessage.getMessageID() + " " + chipsterMessage.getClass());
        }
    }

    public String getName() {
        return "toolbox";
    }

    public void shutdown() {
        this.logger.info("shutdown requested");
        try {
            this.toolboxRestService.close();
        }
        catch (Exception e) {
            this.logger.warn("closing toolbox rest service failed", (Throwable)e);
        }
        try {
            this.endpoint.close();
        }
        catch (Exception e) {
            this.logger.warn("closing messaging endpoint failed", (Throwable)e);
        }
        this.logger.info("shutting down");
    }

    private void handleGetSourceCode(CommandMessage requestMessage) {
        String toolID = new String((String)requestMessage.getParameters().get(0));
        if (toolID == null || toolID.isEmpty()) {
            this.logger.warn("invalid source code request, tool id is: " + toolID);
            return;
        }
        ToolboxTool tool = this.toolboxRestService.getToolbox().getTool(toolID);
        if (tool != null) {
            String source = tool.getSadlString() + tool.getCode();
            this.logger.info("sending source code for " + toolID);
            SourceMessage sourceMessage = new SourceMessage(source);
            if (sourceMessage != null) {
                this.sendReplyMessage((ChipsterMessage)requestMessage, (ChipsterMessage)sourceMessage);
                return;
            }
        } else {
            this.logger.warn("tool " + toolID + " not found");
        }
    }

    private void handleGetDescriptions(CommandMessage requestMessage) throws IOException, SAXException, ParserConfigurationException {
        this.logger.info("sending all descriptions");
        for (ModuleDescriptionMessage descriptionMessage : this.toolboxRestService.getToolbox().getModuleDescriptions()) {
            descriptionMessage.setReplyTo(requestMessage.getReplyTo());
            this.logger.info("sending descriptions for module " + descriptionMessage.getModuleName());
            this.sendReplyMessage((ChipsterMessage)requestMessage, (ChipsterMessage)descriptionMessage);
        }
    }

    private void sendReplyMessage(final ChipsterMessage original, final ChipsterMessage reply) {
        reply.setReplyTo(original.getReplyTo());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ToolboxServer.this.endpoint.replyToMessage(original, reply);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static void main(String[] args) throws Exception {
        new ToolboxServer(null);
    }
}

