/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import fi.csc.chipster.comp.RestPhenodataUtils;
import fi.csc.chipster.filebroker.RestFileBrokerClient;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessionworker.ExtractedSession;
import fi.csc.chipster.sessionworker.NonClosableInputStream;
import fi.csc.microarray.client.session.SessionLoader;
import fi.csc.microarray.client.session.SessionLoaderImpl2;
import fi.csc.microarray.client.session.schema2.DataType;
import fi.csc.microarray.client.session.schema2.InputType;
import fi.csc.microarray.client.session.schema2.LocationType;
import fi.csc.microarray.client.session.schema2.OperationType;
import fi.csc.microarray.client.session.schema2.ParameterType;
import fi.csc.microarray.client.session.schema2.SessionType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class XmlSession {
    private static final Logger logger = LogManager.getLogger();

    public static ExtractedSession extractSession(RestFileBrokerClient fileBroker, SessionDbClient sessionDb, UUID sessionId, UUID zipDatasetId) {
        try {
            if (!XmlSession.isValid(fileBroker, sessionId, zipDatasetId)) {
                return null;
            }
            SessionType sessionType = null;
            Session session = null;
            HashMap<String, String> entryToDatasetIdMap = null;
            HashMap<UUID, UUID> datasetIdMap = new HashMap<UUID, UUID>();
            try (ZipInputStream zipInputStream = new ZipInputStream(fileBroker.download(sessionId, zipDatasetId));){
                ZipEntry entry;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    if (entry.getName().equals("session.xml")) {
                        sessionType = SessionLoaderImpl2.parseXml((InputStream)new NonClosableInputStream(zipInputStream));
                        XmlSession.convertJobIds(sessionType);
                        session = XmlSession.getSession(sessionType);
                        session.setName(sessionDb.getSession(sessionId).getName());
                        entryToDatasetIdMap = XmlSession.getEntryToDatasetIdMap(sessionType);
                        continue;
                    }
                    if (entryToDatasetIdMap.containsKey(entry.getName())) {
                        UUID datasetId = sessionDb.createDataset(sessionId, new Dataset());
                        datasetIdMap.put(UUID.fromString((String)entryToDatasetIdMap.get(entry.getName())), datasetId);
                        fileBroker.upload(sessionId, datasetId, new NonClosableInputStream(zipInputStream));
                        continue;
                    }
                    if (entry.getName().startsWith("source-code-")) {
                        logger.info("omitted source code " + entry.getName());
                        continue;
                    }
                    logger.info("unknown file " + entry.getName());
                }
            }
            XmlSession.convertPhenodata(sessionType, session, sessionId, datasetIdMap, fileBroker, sessionDb);
            return new ExtractedSession(session, datasetIdMap);
        }
        catch (RestException | IOException | JAXBException | ParserConfigurationException | SAXException e) {
            throw new InternalServerErrorException("failed to extract the session", e);
        }
    }

    private static void convertPhenodata(SessionType sessionType, Session session, UUID sessionId, HashMap<UUID, UUID> datasetIdMap, RestFileBrokerClient fileBroker, SessionDbClient sessionDb) throws RestException {
        HashSet<UUID> convertedPhenodatas = new HashSet<UUID>();
        for (DataType dataType : sessionType.getData()) {
            DataType phenodataDataType;
            if (!dataType.getName().toLowerCase().endsWith(".tsv") || (phenodataDataType = XmlSession.findPhenodata(sessionType, session, dataType)) == null) continue;
            UUID oldPhenodataId = UUID.fromString(phenodataDataType.getDataId());
            UUID newPhenodataId = datasetIdMap.get(oldPhenodataId);
            try {
                InputStream phenodata = fileBroker.download(sessionId, newPhenodataId);
                Throwable throwable = null;
                try {
                    ArrayList<MetadataEntry> newPhenodata = RestPhenodataUtils.parseMetadata(phenodata, false, "");
                    session.getDatasets().get(UUID.fromString(dataType.getDataId())).setMetadata(newPhenodata);
                    convertedPhenodatas.add(oldPhenodataId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (phenodata == null) continue;
                    if (throwable != null) {
                        try {
                            phenodata.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    phenodata.close();
                }
            }
            catch (RestException | IOException e) {
                logger.error("failed to get the phenodata file", (Throwable)e);
            }
        }
        for (UUID datasetId : convertedPhenodatas) {
            session.getDatasetCollection().removeIf(d -> datasetId.equals(d.getDatasetId()));
            sessionDb.deleteDataset(sessionId, datasetIdMap.get(datasetId));
        }
    }

    private static DataType findPhenodata(SessionType sessionType, Session session, DataType dataType) {
        List<DataType> phenodatas;
        DataType parent = dataType;
        do {
            if ((phenodatas = XmlSession.getReverseLinked(sessionType, parent, DataBean.Link.ANNOTATION)).size() != 1) continue;
            return phenodatas.get(0);
        } while (phenodatas.size() <= 1 && (parent = XmlSession.getParent(sessionType, parent)) != null);
        return null;
    }

    private static List<DataType> getLinked(SessionType sessionType, DataType dataType, DataBean.Link linkType) {
        Set linkedDataIds = dataType.getLink().stream().filter(l -> linkType == DataBean.Link.valueOf((String)l.getType())).map(l -> l.getTarget()).collect(Collectors.toSet());
        return sessionType.getData().stream().filter(d -> linkedDataIds.contains(d.getId())).collect(Collectors.toList());
    }

    private static List<DataType> getReverseLinked(SessionType sessionType, DataType dataType, DataBean.Link linkType) {
        return sessionType.getData().stream().filter(d -> d.getLink().stream().filter(l -> linkType == DataBean.Link.valueOf((String)l.getType())).filter(l -> dataType.getId().equals(l.getTarget())).findAny().isPresent()).collect(Collectors.toList());
    }

    private static DataType getParent(SessionType sessionType, DataType dataType) {
        List<DataType> parents = XmlSession.getLinked(sessionType, dataType, DataBean.Link.DERIVATION);
        if (parents.size() == 1) {
            return parents.get(0);
        }
        return null;
    }

    private static void convertJobIds(SessionType sessionType) {
        HashMap<String, String> jobIdMap = new HashMap<String, String>();
        for (OperationType operationType : sessionType.getOperation()) {
            UUID newId = RestUtils.createUUID();
            jobIdMap.put(operationType.getId(), newId.toString());
            operationType.setId(newId.toString());
        }
        for (DataType dataType : sessionType.getData()) {
            dataType.setResultOf((String)jobIdMap.get(dataType.getResultOf()));
        }
    }

    private static HashMap<String, String> getEntryToDatasetIdMap(SessionType sessionType) {
        HashMap<String, String> entryToDatasetIdMap = new HashMap<String, String>();
        for (DataType dataType : sessionType.getData()) {
            boolean found = false;
            for (LocationType locationType : dataType.getLocation()) {
                if (!DataManager.StorageMethod.LOCAL_SESSION_ZIP.toString().equals(locationType.getMethod())) continue;
                found = true;
                String url = locationType.getUrl();
                String entryName = url.substring(url.indexOf("#") + 1);
                entryToDatasetIdMap.put(entryName, dataType.getDataId());
            }
            if (found) continue;
            throw new BadRequestException("file content of " + dataType.getName() + " not found");
        }
        return entryToDatasetIdMap;
    }

    private static boolean isValid(RestFileBrokerClient fileBroker, UUID sessionId, UUID zipDatasetId) throws IOException, RestException, SAXException, ParserConfigurationException {
        try (ZipInputStream zipInputStream = new ZipInputStream(fileBroker.download(sessionId, zipDatasetId));){
            ZipEntry entry = zipInputStream.getNextEntry();
            if (entry != null && entry.getName().equals("session.xml")) {
                String version = SessionLoader.getSessionVersion((InputStream)zipInputStream);
                if ("2".equals(version)) {
                    boolean bl = true;
                    return bl;
                }
                if ("1".equals(version)) {
                    throw new BadRequestException("old session format is not supported, please save the session again with the latest Java client");
                }
            }
        }
        return false;
    }

    private static Session getSession(SessionType sessionType) {
        Session session = new Session();
        session.setAccessed(null);
        session.setCreated(LocalDateTime.now());
        session.setNotes(sessionType.getNotes());
        session.setDatasets(XmlSession.getDatasets(sessionType.getData()));
        session.setJobs(XmlSession.getJobs(sessionType.getOperation()));
        return session;
    }

    private static Map<UUID, Job> getJobs(List<OperationType> operationTypes) {
        return operationTypes.stream().map(XmlSession::getJob).collect(Collectors.toMap(Job::getJobId, j -> j));
    }

    private static LinkedHashSet<Parameter> getParameters(List<ParameterType> parameterTypes) {
        return parameterTypes.stream().map(XmlSession::getParameter).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static LinkedHashSet<Input> getInputs(List<InputType> inputTypes) {
        return inputTypes.stream().map(XmlSession::getInput).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Map<UUID, Dataset> getDatasets(List<DataType> dataTypes) {
        return dataTypes.stream().map(XmlSession::getDataset).collect(Collectors.toMap(Dataset::getDatasetId, d -> d));
    }

    private static Job getJob(OperationType operationType) {
        Job job = new Job();
        if (operationType.getId() != null) {
            job.setJobId(UUID.fromString(operationType.getId()));
        }
        if (operationType.getStartTime() != null) {
            job.setStartTime(RestUtils.toLocalDateTime(operationType.getStartTime().toGregorianCalendar().getTime()));
        }
        if (operationType.getEndTime() != null) {
            job.setEndTime(RestUtils.toLocalDateTime(operationType.getEndTime().toGregorianCalendar().getTime()));
        }
        job.setModule(operationType.getModule());
        job.setToolCategory(operationType.getCategory());
        job.setScreenOutput(Strings.delimit((Iterable)operationType.getOutput(), (String)"\n"));
        job.setState(JobState.COMPLETED);
        job.setToolDescription(operationType.getName().getDescription());
        job.setToolId(operationType.getName().getId());
        job.setToolName(operationType.getName().getDisplayName());
        job.setInputs(XmlSession.getInputs(operationType.getInput()));
        job.setParameters(XmlSession.getParameters(operationType.getParameter()));
        return job;
    }

    private static Parameter getParameter(ParameterType parameterType) {
        Parameter parameter = new Parameter();
        parameter.setParameterId(parameterType.getName().getId());
        parameter.setDisplayName(parameterType.getName().getDisplayName());
        parameter.setDescription(parameterType.getName().getDescription());
        parameter.setValue(parameterType.getValue());
        return parameter;
    }

    private static Input getInput(InputType inputType) {
        Input input = new Input();
        input.setDatasetId(inputType.getDataId());
        input.setDisplayName(inputType.getName().getDisplayName());
        input.setDescription(inputType.getName().getDescription());
        input.setInputId(inputType.getName().getId());
        return input;
    }

    private static Dataset getDataset(DataType dataType) {
        Dataset dataset = new Dataset();
        dataset.setDatasetId(UUID.fromString(dataType.getDataId()));
        dataset.setName(dataType.getName());
        dataset.setNotes(dataType.getNotes());
        dataset.setX(dataType.getLayoutX());
        dataset.setY(dataType.getLayoutY());
        dataset.setCreated(RestUtils.toLocalDateTime(dataType.getCreationTime().toGregorianCalendar().getTime()));
        dataset.setSourceJob(UUID.fromString(dataType.getResultOf()));
        return dataset;
    }
}

