/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import fi.csc.chipster.filebroker.RestFileBrokerClient;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessionworker.ExtractedSession;
import fi.csc.chipster.sessionworker.InputStreamEntry;
import fi.csc.chipster.sessionworker.NonClosableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonSession {
    private static final Logger logger = LogManager.getLogger();
    private static final String SESSION_JSON = "session.json";
    private static final String DATASETS_JSON = "datasets.json";
    private static final String JOBS_JSON = "jobs.json";
    protected static final List<String> compressedExtensions = Arrays.asList(".gz", ".zip", ".bam");

    public static ExtractedSession extractSession(RestFileBrokerClient fileBroker, SessionDbClient sessionDb, UUID sessionId, UUID zipDatasetId) throws IOException, RestException {
        try (ZipInputStream zipInputStream = new ZipInputStream(fileBroker.download(sessionId, zipDatasetId));){
            ZipEntry entry = zipInputStream.getNextEntry();
            if (entry == null || !entry.getName().equals(SESSION_JSON)) {
                ExtractedSession extractedSession = null;
                return extractedSession;
            }
        }
        Session session = null;
        Collection datasets = null;
        Collection jobs = null;
        HashMap<UUID, UUID> datasetIdMap = new HashMap<UUID, UUID>();
        try (ZipInputStream zipInputStream = new ZipInputStream(fileBroker.download(sessionId, zipDatasetId));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.getName().equals(SESSION_JSON)) {
                    session = RestUtils.parseJson(Session.class, IOUtils.toString((InputStream)zipInputStream));
                    continue;
                }
                if (entry.getName().equals(DATASETS_JSON)) {
                    datasets = RestUtils.parseJson(List.class, Dataset.class, IOUtils.toString((InputStream)zipInputStream));
                    continue;
                }
                if (entry.getName().equals(JOBS_JSON)) {
                    jobs = RestUtils.parseJson(List.class, Job.class, IOUtils.toString((InputStream)zipInputStream));
                    continue;
                }
                UUID datasetId = sessionDb.createDataset(sessionId, new Dataset());
                datasetIdMap.put(UUID.fromString(entry.getName()), datasetId);
                fileBroker.upload(sessionId, datasetId, new NonClosableInputStream(zipInputStream));
            }
        }
        session.setDatasets(datasets.stream().collect(Collectors.toMap(d -> d.getDatasetId(), d -> d)));
        session.setJobs(jobs.stream().collect(Collectors.toMap(j -> j.getJobId(), j -> j)));
        return new ExtractedSession(session, datasetIdMap);
    }

    public static void packageSession(SessionDbClient sessionDb, final RestFileBrokerClient fileBroker, Session session, final UUID sessionId, ArrayList<InputStreamEntry> entries) throws RestException {
        Collection<Dataset> datasets = sessionDb.getDatasets(sessionId).values();
        Collection<Job> jobs = sessionDb.getJobs(sessionId).values();
        String sessionJson = RestUtils.asJson(session, true);
        String datasetsJson = RestUtils.asJson(datasets, true);
        String jobsJson = RestUtils.asJson(jobs, true);
        entries.add(new InputStreamEntry(SESSION_JSON, sessionJson));
        entries.add(new InputStreamEntry(DATASETS_JSON, datasetsJson));
        entries.add(new InputStreamEntry(JOBS_JSON, jobsJson));
        for (final Dataset dataset : datasets) {
            entries.add(new InputStreamEntry(dataset.getDatasetId().toString(), new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return fileBroker.download(sessionId, dataset.getDatasetId());
                }
            }, JsonSession.getCompressionLevel(dataset.getName())));
        }
    }

    private static int getCompressionLevel(String name) {
        for (String extension : compressedExtensions) {
            if (!name.endsWith(extension)) continue;
            return 0;
        }
        return 1;
    }
}

