/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Rule;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.resource.RuleResource;
import fi.csc.chipster.sessiondb.resource.RuleTable;
import fi.csc.chipster.sessiondb.resource.SessionDatasetResource;
import fi.csc.chipster.sessiondb.resource.SessionJobResource;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.SessionEventListener;

@Path(value="sessions")
@RolesAllowed(value={"client", "server"})
public class SessionResource {
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;
    private PubSubServer events;
    private RuleTable ruleTable;
    private Config config;

    public SessionResource(HibernateUtil hibernate, RuleTable authorizationTable, Config config) {
        this.hibernate = hibernate;
        this.ruleTable = authorizationTable;
        this.config = config;
        this.ruleTable.setRuleRemovedListener(this);
    }

    @Path(value="{id}/datasets")
    public SessionDatasetResource getDatasetResource(@PathParam(value="id") UUID id) {
        return new SessionDatasetResource(this, id);
    }

    @Path(value="{id}/jobs")
    public SessionJobResource getJobResource(@PathParam(value="id") UUID id) {
        return new SessionJobResource(this, id);
    }

    @Path(value="{id}/rules")
    public RuleResource getAuthorizationResource(@PathParam(value="id") UUID id) {
        return new RuleResource(this, id, this.ruleTable, this.config);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Transaction
    public Response get(@PathParam(value="id") UUID sessionId, @Context SecurityContext sc) throws IOException {
        Session result = this.ruleTable.getSessionForReading(sc, sessionId);
        if (result == null) {
            throw new NotFoundException();
        }
        result.setAccessed(LocalDateTime.now());
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transaction
    public Response getAll(@Context SecurityContext sc) {
        List<Rule> result = this.ruleTable.getRules(sc.getUserPrincipal().getName());
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Rule auth : result) {
            sessions.add(auth.getSession());
        }
        return Response.ok(this.toJaxbList(sessions)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transaction
    public Response post(Session session, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        if (session.getSessionId() != null) {
            throw new BadRequestException("session already has an id, post not allowed");
        }
        UUID id = RestUtils.createUUID();
        session.setSessionId(id);
        session.setCreated(LocalDateTime.now());
        session.setAccessed(LocalDateTime.now());
        String username = sc.getUserPrincipal().getName();
        if (username == null) {
            throw new NotAuthorizedException("username is null");
        }
        Rule auth = new Rule(username, true, null);
        auth.setRuleId(RestUtils.createUUID());
        auth.setSession(session);
        session.setRules(new LinkedHashSet<Rule>(Arrays.asList(auth)));
        this.create(session, auth, this.getHibernate().session());
        URI uri = uriInfo.getAbsolutePathBuilder().path(id.toString()).build(new Object[0]);
        ObjectNode json = new JsonNodeFactory(false).objectNode();
        json.put("sessionId", id.toString());
        return Response.created((URI)uri).entity((Object)json).build();
    }

    public void create(Session session, Rule auth, org.hibernate.Session hibernateSession) {
        hibernateSession.save((Object)session);
        this.ruleTable.save(auth, hibernateSession);
        UUID sessionId = session.getSessionId();
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.SESSION, sessionId, SessionEvent.EventType.CREATE), hibernateSession);
        this.publish("authorizations", new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, auth.getRuleId(), SessionEvent.EventType.CREATE), hibernateSession);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Transaction
    public Response put(Session requestSession, @PathParam(value="id") UUID sessionId, @Context SecurityContext sc) {
        requestSession.setSessionId(sessionId);
        this.ruleTable.getSessionForWriting(sc, sessionId);
        requestSession.setAccessed(LocalDateTime.now());
        this.update(requestSession, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void update(Session session, org.hibernate.Session hibernateSession) {
        UUID sessionId = session.getSessionId();
        hibernateSession.merge((Object)session);
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.SESSION, sessionId, SessionEvent.EventType.UPDATE), hibernateSession);
    }

    @DELETE
    @Path(value="{id}")
    @Transaction
    public Response delete(@PathParam(value="id") UUID id, @Context SecurityContext sc) {
        Session session = this.ruleTable.getSessionForWriting(sc, id);
        for (Rule authorization : this.ruleTable.getRules(session.getSessionId())) {
            this.ruleTable.delete(id, authorization, this.hibernate.session());
        }
        return Response.noContent().build();
    }

    public void deleteSession(Rule auth, org.hibernate.Session hibernateSession) {
        UUID sessionId = auth.getSession().getSessionId();
        for (Dataset dataset : auth.getSession().getDatasets().values()) {
            this.getDatasetResource(sessionId).deleteDataset(dataset, hibernateSession);
        }
        for (Job job : auth.getSession().getJobs().values()) {
            this.getJobResource(sessionId).deleteJob(job, hibernateSession);
        }
        for (Rule rule : auth.getSession().getRules()) {
            hibernateSession.delete((Object)rule);
        }
        hibernateSession.delete((Object)auth.getSession());
        this.publish(sessionId.toString(), new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, sessionId, SessionEvent.EventType.DELETE), hibernateSession);
        this.publish("authorizations", new SessionEvent(sessionId, SessionEvent.ResourceType.AUTHORIZATION, auth.getRuleId(), SessionEvent.EventType.DELETE), hibernateSession);
    }

    private GenericEntity<List<Session>> toJaxbList(List<Session> result) {
        return new GenericEntity<List<Session>>(result){};
    }

    public HibernateUtil getHibernate() {
        return this.hibernate;
    }

    public void setPubSubServer(PubSubServer pubSubServer) {
        this.events = pubSubServer;
    }

    public void publish(final String topic, final SessionEvent obj, org.hibernate.Session hibernateSession) {
        hibernateSession.addEventListeners(new SessionEventListener[]{new BaseSessionEventListener(){

            public void transactionCompletion(boolean successful) {
                SessionResource.this.events.publish(topic, obj);
                if (SessionEvent.ResourceType.JOB == obj.getResourceType()) {
                    SessionResource.this.events.publish("jobs", obj);
                }
                if (SessionEvent.ResourceType.SESSION == obj.getResourceType()) {
                    SessionResource.this.events.publish("sessions", obj);
                }
                if (SessionEvent.ResourceType.DATASET == obj.getResourceType()) {
                    SessionResource.this.events.publish("datasets", obj);
                }
            }
        }});
    }

    public RuleTable getRuleTable() {
        return this.ruleTable;
    }

    public void ruleRemoved(UUID sessionId, Rule rule) {
        logger.info("rule deleted, username " + rule.getUsername());
        long count = this.ruleTable.getRules(sessionId).stream().filter(r -> r.isReadWrite() && !"everyone".equals(r.getUsername())).count();
        if (count == 0L) {
            logger.info("last rule deleted, delete the session too");
            this.deleteSession(rule, this.getHibernate().session());
        } else {
            logger.info(count + " rules left, session kept");
        }
    }
}

