/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.scheduler.IdPair;
import fi.csc.microarray.messaging.JobState;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="jobs")
public class GlobalJobResource {
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;

    public GlobalJobResource(HibernateUtil hibernate) {
        this.hibernate = hibernate;
    }

    @GET
    @RolesAllowed(value={"scheduler"})
    @Produces(value={"application/json"})
    @Transaction
    public Response getAll(@QueryParam(value="state") String stateString, @Context SecurityContext sc) {
        if (stateString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"query parameter 'state' is mandatory").build();
        }
        try {
            JobState state = JobState.valueOf((String)stateString);
            List jobs = this.hibernate.session().createQuery("from Job where state=:state").setParameter("state", (Object)state).list();
            List idPairs = jobs.stream().map(job -> new IdPair(job.getSession().getSessionId(), job.getJobId())).collect(Collectors.toList());
            return Response.ok(idPairs).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"invalid state").build();
        }
    }
}

