/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.model;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import fi.csc.chipster.sessiondb.model.File;
import fi.csc.chipster.sessiondb.model.MetadataEntry;
import fi.csc.chipster.sessiondb.model.Session;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@XmlRootElement
public class Dataset {
    @Id
    @Column(columnDefinition="uuid", updatable=false)
    private UUID datasetId;
    private String name;
    @Lob
    private String notes;
    private Integer x;
    private Integer y;
    private UUID sourceJob;
    private LocalDateTime created;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="sessionId")
    private Session session;
    @ManyToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="fileId")
    @JsonUnwrapped
    private File file;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="datasetId")
    private List<MetadataEntry> metadata;
    private HashMap<String, String> typeTags;

    public UUID getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(UUID id) {
        this.datasetId = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public UUID getSourceJob() {
        return this.sourceJob;
    }

    public void setSourceJob(UUID sourceJob) {
        this.sourceJob = sourceJob;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file != null && !file.isEmpty() ? file : null;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public List<MetadataEntry> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataEntry> metadata) {
        this.metadata = metadata;
    }

    @XmlTransient
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="TypeTag", joinColumns={@JoinColumn(name="datasetId")})
    @MapKeyColumn(name="key")
    @Column(name="value")
    public HashMap<String, String> getTypeTags() {
        return this.typeTags;
    }

    public void setTypeTags(HashMap<String, String> typeTags) {
        this.typeTags = typeTags;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    @Entity
    public static class ColumnMetadata {
        @ElementCollection(fetch=FetchType.EAGER)
        @MapKeyColumn(name="key")
        @Column(name="value")
        @CollectionTable(name="Metadata", joinColumns={@JoinColumn(name="datasetId")})
        private Map<String, String> metadata;
    }
}

