/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.servicelocator;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.servicelocator.resource.ServiceCatalog;
import fi.csc.chipster.servicelocator.resource.ServiceResource;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class ServiceLocator {
    private Logger logger = LogManager.getLogger();
    private String serverId;
    private ServiceCatalog serviceCatalog;
    private AuthenticationClient authService;
    private Config config;
    private HttpServer httpServer;
    private HttpServer adminServer;

    public ServiceLocator(Config config) {
        this.config = config;
    }

    public void startServer() throws IOException {
        String username = "service-locator";
        String password = this.config.getPassword(username);
        String authUri = this.config.getInternalServiceUrls().get("auth");
        List<String> auths = Arrays.asList(authUri);
        this.authService = new AuthenticationClient(auths, username, password);
        this.serverId = RestUtils.createId();
        this.serviceCatalog = new ServiceCatalog();
        Map<String, String> intServices = this.config.getInternalServiceUrls();
        Map<String, String> extServices = this.config.getExternalServiceUrls();
        HashSet<String> services = new HashSet<String>();
        services.addAll(intServices.keySet());
        services.addAll(extServices.keySet());
        for (String service : services) {
            this.addService(service, intServices.get(service), extServices.get(service));
        }
        this.serviceCatalog.setReadOnly(true);
        TokenRequestFilter tokenRequestFilter = new TokenRequestFilter(this.authService);
        tokenRequestFilter.authenticationRequired(false, false);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)new ServiceResource(this.serviceCatalog)).register((Object)tokenRequestFilter);
        JerseyStatisticsSource jerseyStatisticsSource = RestUtils.createJerseyStatisticsSource(rc);
        URI baseUri = URI.create(this.config.getBindUrl("service-locator"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc, (boolean)false);
        jerseyStatisticsSource.collectConnectionStatistics(this.httpServer);
        this.httpServer.start();
        this.adminServer = RestUtils.startAdminServer("service-locator", this.config, this.authService, jerseyStatisticsSource);
    }

    public void addService(String role, String uri, String publicUri) {
        Service service = new Service(role, uri, publicUri);
        this.serviceCatalog.add(role, service);
    }

    public static void main(String[] args) throws IOException {
        ServiceLocator service = new ServiceLocator(new Config());
        RestUtils.shutdownGracefullyOnInterrupt(service.getHttpServer(), "service-locator");
        service.startServer();
        RestUtils.waitForShutdown("service locator", service.getHttpServer());
    }

    private HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void close() {
        RestUtils.shutdown("service-locator-admin", this.adminServer);
        RestUtils.shutdown("service-locator", this.httpServer);
    }
}

