/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import com.mchange.rmi.NotAuthorizedException;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StatusSource;
import fi.csc.chipster.rest.token.PubSubTokenServletFilter;
import fi.csc.chipster.rest.websocket.PubSubEndpoint;
import fi.csc.chipster.rest.websocket.Subscriber;
import fi.csc.chipster.rest.websocket.Topic;
import fi.csc.chipster.rest.websocket.TopicConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class PubSubServer
implements StatusSource {
    private static final Logger logger = LogManager.getLogger();
    public static final String DEFAULT_TOPIC = "default-topic";
    ConcurrentHashMap<String, Topic> topics = new ConcurrentHashMap();
    private MessageHandler.Whole<String> replyHandler;
    private Server server;
    private String baseUri;
    private String path;
    private TopicConfig topicConfig;
    private String name;
    private int messagesDiscarded;
    private int messagesReceived;
    private int messagesSent;
    private int subsribeCount;
    private int bytesReceived;
    private int bytesSent;
    private long idleTimeout = 0L;

    public PubSubServer(String baseUri, String path, MessageHandler.Whole<String> replyHandler, TopicConfig topicCheck, String name) throws ServletException, DeploymentException {
        this.baseUri = baseUri;
        this.path = path;
        this.replyHandler = replyHandler;
        this.topicConfig = topicCheck;
        this.name = name;
        this.init();
    }

    public void init() throws DeploymentException, ServletException {
        this.server = new Server();
        URI uri = URI.create(this.baseUri);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(uri.getHost());
        connector.setPort(uri.getPort());
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        String contextPath = uri.getPath().replaceAll("/$", "");
        if (contextPath.isEmpty()) {
            contextPath = "/";
        }
        logger.debug("context path " + contextPath);
        context.setContextPath(contextPath);
        PubSubTokenServletFilter filter = new PubSubTokenServletFilter(this.topicConfig, contextPath + this.path);
        context.addFilter(new FilterHolder((Filter)filter), "/*", null);
        this.server.setHandler((Handler)context);
        ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
        ServerEndpointConfig serverConfig = ServerEndpointConfig.Builder.create(PubSubEndpoint.class, (String)("/" + this.path)).build();
        serverConfig.getUserProperties().put(this.getClass().getName(), this);
        wscontainer.addEndpoint(serverConfig);
    }

    public void publish(Object obj) {
        this.publish(DEFAULT_TOPIC, RestUtils.asJson(obj));
    }

    public void publish(String topic, Object obj) {
        this.publish(topic, RestUtils.asJson(obj));
    }

    private void publish(String topicName, String msg) {
        Topic topic = this.topics.get(topicName);
        if (topic != null) {
            topic.publish(msg);
            this.messagesSent += topic.getSubscribers().size();
            this.bytesSent += topic.getSubscribers().size() * msg.length();
        } else {
            ++this.messagesDiscarded;
            logger.debug("no one listening on topic: " + topicName);
        }
        ++this.messagesReceived;
        this.bytesReceived += msg.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topicName, Subscriber s) {
        if (topicName == null) {
            topicName = DEFAULT_TOPIC;
        }
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            if (!this.topics.containsKey(topicName)) {
                logger.debug("topic " + topicName + " not found, create it");
                this.topics.put(topicName, new Topic());
            }
            Topic topic = this.topics.get(topicName);
            topic.add(s);
            ++this.subsribeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topicName, RemoteEndpoint.Basic basicRemote) {
        if (topicName == null) {
            topicName = DEFAULT_TOPIC;
        }
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            Topic topic = this.topics.get(topicName);
            topic.remove(basicRemote);
            if (topic.isEmpty()) {
                logger.debug("topic " + topicName + " is empty, remove it");
                this.topics.remove(topicName);
            }
        }
    }

    public MessageHandler.Whole<String> getMessageHandler() {
        return this.replyHandler;
    }

    public void stop() {
        try {
            this.server.stop();
            logger.info("stopped a pub-sub server: " + this.name);
        }
        catch (Exception e) {
            logger.warn("failed to stop the pub-sub server", (Throwable)e);
        }
    }

    public void start() {
        try {
            logger.debug("start a pub-sub server: " + this.name);
            this.server.start();
        }
        catch (Exception e) {
            logger.error("failed to start PubSubServer", (Throwable)e);
        }
    }

    public boolean isTopicAuthorized(AuthPrincipal principal, String topic) throws NotAuthorizedException {
        if (this.topicConfig != null) {
            return this.topicConfig.isAuthorized(principal, topic);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            List<String> tags = this.topicConfig.getMonitoringTags();
            for (String tag : tags) {
                Set tagTopics = this.topics.keySet().stream().filter(t -> tag.equals(this.topicConfig.getMonitoringTag((String)t))).collect(Collectors.toSet());
                status.put("wsTopicCount" + tag, tagTopics.size());
                status.put("wsSubscribersCurrent" + tag, tagTopics.stream().mapToInt(t -> this.topics.get(t).getSubscribers().size()).sum());
            }
            status.put("wsMessagesDiscarded", this.messagesDiscarded);
            status.put("wsMessagesReceived", this.messagesReceived);
            status.put("wsMessagesSent", this.messagesSent);
            status.put("wsSubscribersTotal", this.subsribeCount);
            status.put("wsBytesSent", this.bytesSent);
            status.put("wsBytesReceived", this.bytesReceived);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getTopics() {
        ConcurrentHashMap<String, Topic> concurrentHashMap = this.topics;
        synchronized (concurrentHashMap) {
            HashMap<String, Object> topicsCopy = new HashMap<String, Object>();
            for (String topicName : this.topics.keySet()) {
                ArrayList subscribersCopy = new ArrayList();
                ConcurrentHashMap<RemoteEndpoint.Basic, Subscriber> subscribers = this.topics.get(topicName).getSubscribers();
                for (RemoteEndpoint.Basic remote : subscribers.keySet()) {
                    Subscriber subscriber = subscribers.get(remote);
                    HashMap<String, Object> subscriberCopy = new HashMap<String, Object>();
                    subscriberCopy.put("address", subscriber.getRemoteAddress());
                    subscriberCopy.put("username", subscriber.getUsername());
                    subscriberCopy.put("created", subscriber.getCreated());
                    subscribersCopy.add(subscriberCopy);
                }
                topicsCopy.put(topicName, subscribersCopy);
            }
            return topicsCopy;
        }
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long timeout) {
        this.idleTimeout = timeout;
    }
}

