/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.token;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.auth.resource.AuthSecurityContext;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.token.BasicAuthParser;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
@Priority(value=1000)
public class TokenRequestFilter
implements ContainerRequestFilter {
    private static final Logger logger = LogManager.getLogger();
    public static final String QUERY_PARAMETER_TOKEN = "token";
    public static final String HEADER_AUTHORIZATION = "authorization";
    public static final String TOKEN_USER = "token";
    private static final Duration TOKEN_CACHE_LIFETIME = Duration.of(10L, ChronoUnit.SECONDS);
    private Map<String, Token> tokenCache = new HashMap<String, Token>();
    private boolean authenticationRequired = true;
    private AuthenticationClient authService;
    private boolean passwordRequired = true;
    private Timer tokenCacheTimer = new Timer("token cache cleanup", true);

    public TokenRequestFilter(AuthenticationClient authService) {
        this.authService = authService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authParameter;
        if ("OPTIONS".equals(requestContext.getMethod())) {
            return;
        }
        String authHeader = requestContext.getHeaderString(HEADER_AUTHORIZATION);
        String password = TokenRequestFilter.getToken(authHeader, authParameter = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"token"));
        if (password == null) {
            if (this.passwordRequired) {
                throw new NotAuthorizedException("password or token required");
            }
            if (!this.authenticationRequired) {
                requestContext.setSecurityContext((SecurityContext)new AuthSecurityContext(new AuthPrincipal(null, "unauthenticated"), requestContext.getSecurityContext()));
                return;
            }
        }
        try {
            AuthPrincipal principal = this.tokenAuthentication(password);
            requestContext.setSecurityContext((SecurityContext)new AuthSecurityContext(principal, requestContext.getSecurityContext()));
        }
        catch (ForbiddenException e) {
            throw new InternalServerErrorException("failed to check the token", (Throwable)e);
        }
        catch (NotFoundException e) {
            if (this.authenticationRequired) {
                throw new ForbiddenException((Throwable)e);
            }
            requestContext.setSecurityContext((SecurityContext)new AuthSecurityContext(new AuthPrincipal(null, password, new HashSet<String>()), requestContext.getSecurityContext()));
            return;
        }
    }

    public static String getToken(String authHeader, String authParameter) {
        if (authHeader != null) {
            BasicAuthParser parser = new BasicAuthParser(authHeader);
            if (!"token".equals(parser.getUsername())) {
                throw new NotAuthorizedException("only tokens allowed");
            }
            return parser.getPassword();
        }
        return authParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthPrincipal tokenAuthentication(final String clientTokenKey) {
        if (clientTokenKey == null) {
            throw new NotAuthorizedException("no authorization header");
        }
        Token dbClientToken = null;
        Map<String, Token> map = this.tokenCache;
        synchronized (map) {
            if (this.tokenCache.containsKey(clientTokenKey)) {
                dbClientToken = this.tokenCache.get(clientTokenKey);
            } else {
                dbClientToken = this.authService.getDbToken(clientTokenKey);
                if (dbClientToken == null) {
                    throw new NotFoundException("token not found");
                }
                this.tokenCache.put(clientTokenKey, dbClientToken);
                this.tokenCacheTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Map map = TokenRequestFilter.this.tokenCache;
                            synchronized (map) {
                                TokenRequestFilter.this.tokenCache.remove(clientTokenKey);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("remove token from cache failed", (Throwable)e);
                        }
                    }
                }, TOKEN_CACHE_LIFETIME.toMillis());
            }
        }
        if (dbClientToken.getValid().isBefore(LocalDateTime.now())) {
            throw new NotFoundException("token expired");
        }
        return new AuthPrincipal(dbClientToken.getUsername(), clientTokenKey, dbClientToken.getRoles());
    }

    public void authenticationRequired(boolean authenticationRequired, boolean passwordRequired) {
        this.authenticationRequired = authenticationRequired;
        this.passwordRequired = passwordRequired;
    }
}

