/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.token;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.websocket.PrincipalRequestWrapper;
import fi.csc.chipster.rest.websocket.TopicConfig;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.uri.UriTemplate;

public class PubSubTokenServletFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger();
    private TopicConfig topicCheck;
    private String pathTemplate;

    public PubSubTokenServletFilter(TopicConfig topicConfig, String pathTemplate) {
        this.topicCheck = topicConfig;
        this.pathTemplate = pathTemplate;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        logger.debug("authenticate request " + request.getRequestURI());
        String tokenKey = request.getParameter("token");
        if (tokenKey == null) {
            logger.debug("no token");
            response.sendError(401, "no token in request");
            return;
        }
        try {
            AuthPrincipal principal = this.topicCheck.getUserPrincipal(tokenKey);
            if (principal != null) {
                if (this.isAuthorized(principal, request)) {
                    logger.debug("authentication ok");
                    filterChain.doFilter((ServletRequest)new PrincipalRequestWrapper(principal, request), (ServletResponse)response);
                    return;
                }
                logger.debug("access denied");
                response.sendError(403, "access denied");
                return;
            }
            logger.debug("token not found");
            response.sendError(403, "token not found from server");
            return;
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
            return;
        }
        catch (ForbiddenException e) {
            response.sendError(403, e.getMessage());
            return;
        }
        catch (NotAuthorizedException e) {
            response.sendError(401, e.getMessage());
            return;
        }
        catch (Exception e) {
            logger.error("error in websocket authentication", (Throwable)e);
            response.sendError(500, "failed to retrieve the token");
            return;
        }
    }

    private boolean isAuthorized(AuthPrincipal principal, HttpServletRequest request) {
        HashMap groupValues = new HashMap();
        String requestPath = URI.create(request.getRequestURI()).getPath();
        if (!new UriTemplate(this.pathTemplate).match((CharSequence)requestPath, groupValues)) {
            logger.warn("uri template matching failed");
            logger.warn("template: " + this.pathTemplate);
            logger.warn("uri:      " + requestPath);
            return false;
        }
        String topic = (String)groupValues.get("topic-name");
        return this.topicCheck.isAuthorized(principal, topic);
    }

    public void destroy() {
    }
}

