/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.AdminResource;
import fi.csc.chipster.rest.CORSResponseFilter;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.JettyStatisticsSource;
import fi.csc.chipster.rest.StatusSource;
import fi.csc.chipster.rest.exception.LocalDateTimeContextResolver;
import fi.csc.chipster.rest.exception.NotFoundExceptionMapper;
import fi.csc.chipster.rest.hibernate.HibernateRequestFilter;
import fi.csc.chipster.rest.hibernate.HibernateResponseFilter;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.pretty.JsonPrettyPrintQueryParamContainerResponseFilter;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.messaging.JobState;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

public class RestUtils {
    private static org.apache.logging.log4j.Logger logger = LogManager.getLogger();
    private static Random rand = new Random();

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new LocalDateTimeContextResolver().getContext(null);
        return mapper;
    }

    public static String asJson(Object obj) {
        return RestUtils.asJson(obj, false);
    }

    public static String asJson(Object obj, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper mapper = RestUtils.getObjectMapper();
            if (pretty) {
                mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, obj);
            } else {
                mapper.writeValue((Writer)writer, obj);
            }
            return writer.toString();
        }
        catch (IOException e) {
            logger.error("json conversion failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static <T> T parseJson(Class<T> obj, String json) {
        return RestUtils.parseJson(obj, json, true);
    }

    public static <T> T parseJson(Class<T> obj, String json, boolean failOnUnknownProperties) {
        try {
            StringReader reader = new StringReader(json);
            ObjectMapper mapper = RestUtils.getObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
            return (T)mapper.readValue((Reader)reader, obj);
        }
        catch (IOException e) {
            logger.error("json parsing failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json) {
        return RestUtils.parseJson(collectionType, itemType, json, true);
    }

    public static List parseJson(Class<? extends Collection> collectionType, Class<?> itemType, String json, boolean failOnUnknownProperties) {
        try {
            StringReader reader = new StringReader(json);
            ObjectMapper mapper = RestUtils.getObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
            return (List)mapper.readValue((Reader)reader, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionType, itemType));
        }
        catch (IOException e) {
            logger.error("json parsing failed", (Throwable)e);
            throw new InternalServerErrorException();
        }
    }

    public static Date toDate(LocalDateTime dateTime) {
        if (dateTime != null) {
            return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date != null) {
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        return null;
    }

    public static String createId() {
        return RestUtils.createUUID().toString();
    }

    public static UUID createUUID() {
        return UUID.randomUUID();
    }

    public static Session getRandomSession() {
        Session s = new Session();
        s.setName("session" + rand.nextInt(1000));
        s.setCreated(LocalDateTime.now());
        s.setAccessed(LocalDateTime.now());
        return s;
    }

    public static Dataset getRandomDataset() {
        Dataset d = new Dataset();
        d.setName("dataset" + d.getDatasetId());
        d.setSourceJob(RestUtils.createUUID());
        d.setX(100);
        d.setY(100);
        return d;
    }

    public static Job getRandomJob() {
        Job j = new Job();
        j.setEndTime(LocalDateTime.now());
        j.setState(JobState.NEW);
        j.setStartTime(LocalDateTime.now());
        j.setToolCategory("utilities");
        j.setToolDescription("very important tool");
        j.setToolId("UtilTool.py");
        j.setToolName("Utility tool");
        LinkedHashSet<Parameter> p = new LinkedHashSet<Parameter>();
        p.add(RestUtils.getRandomParameter());
        p.add(RestUtils.getRandomParameter());
        j.setParameters(p);
        LinkedHashSet<Input> i = new LinkedHashSet<Input>();
        i.add(RestUtils.getRandomInput());
        i.add(RestUtils.getRandomInput());
        j.setInputs(i);
        return j;
    }

    public static Job getRandomCompletedJob() {
        Job j = RestUtils.getRandomJob();
        j.setState(JobState.COMPLETED);
        return j;
    }

    private static Input getRandomInput() {
        Input i = new Input();
        i.setInputId("inFile");
        i.setDisplayName("Input file");
        i.setDescription("Input file to process");
        i.setType("GENERIC");
        i.setDatasetId("apsodifupoiwuerpoiu");
        return i;
    }

    private static Parameter getRandomParameter() {
        Parameter p = new Parameter();
        p.setParameterId(RestUtils.createId());
        p.setDisplayName("Tool parameter");
        p.setDescription("Desckription of the tool parameter");
        p.setType(SADLSyntax.ParameterType.STRING);
        p.setValue("Parameter value");
        return p;
    }

    public static String basename(String path) {
        return new File(path).getName();
    }

    public static Service getRandomService() {
        Service s = new Service();
        s.setRole("session-db");
        s.setServiceId(RestUtils.createId());
        s.setUri("http://localhost:8080/sessionstorage");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForShutdown(String name, HttpServer server) {
        System.out.println(name + " started");
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            logger.error(name + " failed", (Throwable)e);
        }
        finally {
            GrizzlyFuture future = server.shutdown();
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.warn(name + " shutdown failed", (Throwable)e);
            }
        }
    }

    public static ResourceConfig getDefaultResourceConfig() {
        return new ResourceConfig().property("jersey.config.disableAutoDiscovery", (Object)true).register(JacksonJaxbJsonProvider.class).packages(new String[]{NotFoundExceptionMapper.class.getPackage().getName()}).register(CORSResponseFilter.class).register(RolesAllowedDynamicFeature.class).register(JsonPrettyPrintQueryParamContainerResponseFilter.class);
    }

    public static void shutdown(String name, HttpServer httpServer) {
        if (httpServer == null) {
            logger.warn("can't shutdown " + name + ", the server is null");
            return;
        }
        GrizzlyFuture future = httpServer.shutdown();
        try {
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.warn(name + " server didn't stop gracefully");
                httpServer.shutdownNow();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("failed to shutdown the server " + name, (Throwable)e);
        }
    }

    public static boolean isSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    public static void configureForDownload(Response.ResponseBuilder response, String name) {
        response.header("Content-Disposition", (Object)("attachment; filename=\"" + name + "\""));
    }

    public static void configureForDownload(HttpServletResponse response, String name) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
    }

    public static LoggingFeature getLoggingFeature(String string) {
        return new LoggingFeature(Logger.getLogger("session-db"), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
    }

    public static HttpServer startAdminServer(String role, Config config, AuthenticationClient authService, StatusSource ... stats) {
        return RestUtils.startAdminServer((Object)new AdminResource(stats), null, role, config, authService);
    }

    public static HttpServer startAdminServer(Object adminResource, HibernateUtil hibernate, String role, Config config, AuthenticationClient authService) {
        TokenRequestFilter tokenRequestFilter = new TokenRequestFilter(authService);
        tokenRequestFilter.authenticationRequired(false, false);
        return RestUtils.startAdminServer(adminResource, hibernate, role, config, tokenRequestFilter);
    }

    public static HttpServer startAdminServer(Object adminResource, HibernateUtil hibernate, String role, Config config, Object authResource) {
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register(authResource).register(adminResource);
        if (hibernate != null) {
            rc.register((Object)new HibernateRequestFilter(hibernate)).register((Object)new HibernateResponseFilter(hibernate));
        }
        URI baseUri = URI.create(config.getAdminBindUrl(role));
        return GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc);
    }

    public static JerseyStatisticsSource createJerseyStatisticsSource(ResourceConfig rc) {
        JerseyStatisticsSource listener = new JerseyStatisticsSource();
        rc.register((Object)listener).property("jersey.config.server.monitoring.statistics.enabled", (Object)true);
        return listener;
    }

    public static StatusSource createStatisticsListener(Server server) {
        ConnectorStatistics connectorStats = new ConnectorStatistics();
        for (Connector connector : server.getConnectors()) {
            ((ServerConnector)connector).addBean((Object)connectorStats);
        }
        StatisticsHandler requestStats = new StatisticsHandler();
        requestStats.setHandler(server.getHandler());
        server.setHandler((Handler)requestStats);
        return new JettyStatisticsSource(connectorStats, requestStats);
    }

    public static void shutdownGracefullyOnInterrupt(final Server server, int timeout, final String name) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info(name + " interrupted");
                try {
                    logger.info(name + " stops accepting new connections");
                    for (Connector con2 : Arrays.asList(server.getConnectors())) {
                        con2.shutdown();
                    }
                    int pollInterval = 1000;
                    boolean logInterval = true;
                    int timeout = 3600;
                    int connections = 0;
                    LocalDateTime waitStart = LocalDateTime.now();
                    block3: while (true) {
                        for (int i = 0; i < 1; ++i) {
                            connections = Arrays.asList(server.getConnectors()).stream().mapToInt(con -> con.getConnectedEndPoints().size()).sum();
                            if (connections == 0) break block3;
                            if (LocalDateTime.now().isAfter(waitStart.plusSeconds(3600L))) {
                                System.err.println(name + " shutdown wait timeout reached");
                                break block3;
                            }
                            Thread.sleep(1000L);
                        }
                        System.out.println(name + " waiting for remaining " + connections + " connections to complete");
                    }
                    System.out.println(name + " stopping");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void shutdownGracefullyOnInterrupt(final HttpServer server, final int timeout, final String name) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info(name + " interrupted");
                GrizzlyFuture shutdownFuture = server.shutdown((long)timeout, TimeUnit.SECONDS);
                logger.info(name + " stops accepting new connections");
                System.out.println(name + " waiting for the remaining connections to complete");
                try {
                    shutdownFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                System.out.println(name + " stopping");
            }
        });
    }

    public static void shutdownGracefullyOnInterrupt(HttpServer server, String name) {
        RestUtils.shutdownGracefullyOnInterrupt(server, 10, name);
    }

    public static void shutdownGracefullyOnInterrupt(Server server, String name) {
        RestUtils.shutdownGracefullyOnInterrupt(server, 10, name);
    }
}

