/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.filebroker;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.comp.RestPhenodataUtils;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.DbSession;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.messaging.admin.StorageAdminAPI;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class LegacyRestFileBrokerClient
implements FileBrokerClient {
    private static final Logger logger = Logger.getLogger(LegacyRestFileBrokerClient.class);
    private SessionDbClient sessionDbClient;
    private WebTarget fileBrokerTarget;
    private SessionManager sessionManager;

    public LegacyRestFileBrokerClient(SessionDbClient sessionDbClient2, String restProxy, AuthenticationClient authClient, SessionManager sessionManager) {
        this.sessionDbClient = sessionDbClient2;
        this.fileBrokerTarget = authClient.getAuthenticatedClient().target("http://" + restProxy + "/filebroker/");
        this.sessionManager = sessionManager;
    }

    public LegacyRestFileBrokerClient(SessionDbClient sessionDbClient2, ServiceLocatorClient serviceLocator, AuthenticationClient authClient) {
        this.sessionDbClient = sessionDbClient2;
        this.fileBrokerTarget = authClient.getAuthenticatedClient().target(serviceLocator.get("file-broker").get(0));
    }

    public String addFile(UUID jobId, UUID sessionId, FileBrokerClient.FileBrokerArea area, File file, IOUtils.CopyProgressListener progressListener, String datsetName) throws FileBrokerException, IOException {
        UUID datasetId;
        if ("phenodata.tsv".equals(file.getName()) || "phenodata2.tsv".equals(file.getName())) {
            return null;
        }
        Dataset dataset = new Dataset();
        dataset.setSourceJob(jobId);
        dataset.setName(datsetName);
        dataset.setMetadata(RestPhenodataUtils.parseMetadata(file.getParentFile(), file.getName()));
        try {
            datasetId = this.sessionDbClient.createDataset(sessionId, dataset);
            FileInputStream inputStream = new FileInputStream(file);
            this.upload(sessionId, datasetId.toString(), inputStream);
            logger.info((Object)("uploaded dataset " + datasetId.toString()));
        }
        catch (RestException e) {
            throw new FileBrokerException("failed to create a result dataset", (Exception)e);
        }
        return datasetId.toString();
    }

    private void upload(UUID sessionId, String dataId, InputStream inputStream) throws IOException {
        String datasetPath = "sessions/" + sessionId.toString() + "/datasets/" + dataId;
        WebTarget datasetTarget = this.fileBrokerTarget.path(datasetPath);
        this.fileBrokerTarget.property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
        Response response = (Response)datasetTarget.request().put(Entity.entity((Object)inputStream, (String)"application/octet-stream"), Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new IOException("upload failed: " + response.getStatus() + " " + (String)response.readEntity(String.class) + " " + datasetTarget.getUri());
        }
    }

    private UUID getSessionId() {
        return this.sessionManager.getSessionId();
    }

    public String addFile(String dataId, FileBrokerClient.FileBrokerArea area, InputStream file, long contentLength, IOUtils.CopyProgressListener progressListener) throws FileBrokerException, IOException {
        this.upload(this.getSessionId(), dataId, file);
        return null;
    }

    public ChecksumInputStream getInputStream(String dataId) throws IOException, FileBrokerException {
        InputStream remoteStream = this.download(this.getSessionId(), dataId);
        return new ChecksumInputStream(remoteStream, true);
    }

    private InputStream download(UUID sessionId, String dataId) throws FileBrokerException {
        String datasetPath = "sessions/" + sessionId.toString() + "/datasets/" + dataId;
        WebTarget datasetTarget = this.fileBrokerTarget.path(datasetPath);
        Response response = (Response)datasetTarget.request().get(Response.class);
        if (!RestUtils.isSuccessful(response.getStatus())) {
            throw new FileBrokerException("get input stream failed: " + response.getStatus() + " " + (String)response.readEntity(String.class) + " " + datasetTarget.getUri());
        }
        return (InputStream)response.readEntity(InputStream.class);
    }

    public void getFile(UUID sessionId, String dataId, File destFile) throws IOException, FileBrokerException, ChecksumException {
        InputStream inStream = this.download(sessionId, dataId);
        IOUtils.copy((InputStream)inStream, (File)destFile);
    }

    public boolean isAvailable(String dataId, Long contentLength, String checksum, FileBrokerClient.FileBrokerArea area) throws FileBrokerException {
        try {
            InputStream inStream = this.download(this.getSessionId(), dataId);
            IOUtils.closeIfPossible((InputStream)inStream);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public boolean moveFromCacheToStorage(String dataId) throws FileBrokerException, FileBrokerException {
        return true;
    }

    public List<URL> getPublicFiles() throws FileBrokerException {
        return this.fetchPublicFiles();
    }

    private List<URL> fetchPublicFiles() throws FileBrokerException {
        return new ArrayList<URL>();
    }

    public boolean requestDiskSpace(long size) throws FileBrokerException {
        return true;
    }

    public void saveRemoteSession(String sessionName, String sessionId, LinkedList<String> dataIds) throws FileBrokerException {
    }

    public List<DbSession> listRemoteSessions() throws FileBrokerException {
        try {
            HashMap<UUID, Session> sessions = this.sessionDbClient.getSessions();
            LinkedList<DbSession> dbSessions = new LinkedList<DbSession>();
            for (Session session : sessions.values()) {
                dbSessions.add(new DbSession(session.getSessionId().toString(), session.getName(), null));
            }
            return dbSessions;
        }
        catch (RestException e) {
            throw new FileBrokerException(Exceptions.getStackTrace((Throwable)e));
        }
    }

    public StorageAdminAPI.StorageEntryMessageListener getStorageUsage() throws FileBrokerException, InterruptedException {
        return null;
    }

    public List<DbSession> listPublicRemoteSessions() throws FileBrokerException {
        return new LinkedList<DbSession>();
    }

    public void removeRemoteSession(String dataId) throws FileBrokerException {
    }

    public String getExternalURL(String dataId) throws FileBrokerException, MalformedURLException {
        return null;
    }

    public Long getContentLength(String dataId) throws IOException, FileBrokerException {
        return null;
    }
}

