/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.auth.resource.AuthenticationRequestFilter;
import fi.csc.chipster.auth.resource.TokenResource;
import fi.csc.chipster.rest.AdminResource;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JerseyStatisticsSource;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateRequestFilter;
import fi.csc.chipster.rest.hibernate.HibernateResponseFilter;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.microarray.config.ConfigurationLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class AuthenticationService {
    private Logger logger = LogManager.getLogger();
    private static HibernateUtil hibernate;
    private Config config;
    private HttpServer httpServer;
    private HttpServer adminServer;

    public AuthenticationService(Config config) {
        this.config = config;
    }

    public void startServer() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        List<Class<?>> hibernateClasses = Arrays.asList(Token.class);
        hibernate = new HibernateUtil(this.config, "auth");
        hibernate.buildSessionFactory(hibernateClasses);
        TokenResource authResource = new TokenResource(hibernate);
        AuthenticationRequestFilter authRequestFilter = new AuthenticationRequestFilter(hibernate, this.config);
        ResourceConfig rc = RestUtils.getDefaultResourceConfig().register((Object)authResource).register((Object)new HibernateRequestFilter(hibernate)).register((Object)new HibernateResponseFilter(hibernate)).register((Object)authRequestFilter);
        JerseyStatisticsSource jerseyStatisticsSource = RestUtils.createJerseyStatisticsSource(rc);
        AdminResource adminResource = new AdminResource(hibernate, Token.class, jerseyStatisticsSource);
        URI baseUri = URI.create(this.config.getBindUrl("auth"));
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)rc, (boolean)false);
        jerseyStatisticsSource.collectConnectionStatistics(this.httpServer);
        this.httpServer.start();
        URL bindUrl = URI.create(this.config.getBindUrl("auth")).toURL();
        String localhostUrl = new URL(bindUrl.getProtocol(), "localhost", bindUrl.getPort(), bindUrl.getFile()).toString();
        AuthenticationClient authClient = new AuthenticationClient(localhostUrl, "auth", this.config.getPassword("auth"));
        this.adminServer = RestUtils.startAdminServer((Object)adminResource, hibernate, "auth", this.config, authClient);
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        AuthenticationService service = new AuthenticationService(new Config());
        service.startServer();
        RestUtils.shutdownGracefullyOnInterrupt(service.getHttpServer(), "auth");
        RestUtils.waitForShutdown("authentication service", service.getHttpServer());
        hibernate.getSessionFactory().close();
    }

    private HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HibernateUtil getHibernate() {
        return hibernate;
    }

    public void close() {
        RestUtils.shutdown("auth-admin", this.adminServer);
        RestUtils.shutdown("auth", this.httpServer);
    }
}

