/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.DataType;
import org.h2.value.Value;

public class FunctionCursorResultSet
implements Cursor {
    private final Session session;
    private final ResultSet result;
    private final ResultSetMetaData meta;
    private Value[] values;
    private Row row;

    FunctionCursorResultSet(Session session, ResultSet resultSet) {
        this.session = session;
        this.result = resultSet;
        try {
            this.meta = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    public Row get() {
        if (this.values == null) {
            return null;
        }
        if (this.row == null) {
            this.row = this.session.createRow(this.values, 1);
        }
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        this.row = null;
        try {
            if (this.result != null && this.result.next()) {
                int n = this.meta.getColumnCount();
                this.values = new Value[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = DataType.getValueTypeFromResultSet(this.meta, i + 1);
                    this.values[i] = DataType.readValue(this.session, this.result, i + 1, n2);
                }
            } else {
                this.values = null;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        return this.values != null;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

