/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class UrlMessage
extends ChipsterMessage {
    private static final String KEY_URL = "url";
    private URL url;

    public UrlMessage() {
    }

    public UrlMessage(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        String urlString = from.getString(KEY_URL);
        if (urlString == null) {
            this.url = null;
        } else {
            try {
                this.url = new URL(from.getString(KEY_URL));
            }
            catch (MalformedURLException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        String urlString = null;
        if (this.url != null) {
            urlString = this.url.toString();
        }
        mapMessage.setString(KEY_URL, urlString);
    }
}

