/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.ParameterMessage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public class PayloadMessage
extends ParameterMessage {
    private static final Logger logger = Logger.getLogger(PayloadMessage.class);
    private static final String KEY_ID_PREFIX = "payload_id_";
    private static final String KEY_NAME_PREFIX = "payload_name_";
    private Map<String, String> ids = new HashMap<String, String>();
    private Map<String, String> names = new HashMap<String, String>();

    public PayloadMessage() {
    }

    public PayloadMessage(List<String> parameters) {
        super(parameters);
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        try {
            Enumeration keys = from.getMapNames();
            while (keys.hasMoreElements()) {
                String value;
                String payloadName;
                String name = (String)keys.nextElement();
                logger.debug((Object)("examining " + name));
                if (name.startsWith(KEY_ID_PREFIX)) {
                    payloadName = name.substring(KEY_ID_PREFIX.length());
                    value = from.getString(name);
                    this.ids.put(payloadName, value);
                    logger.debug((Object)("Unmarshalled " + name + " -> " + payloadName + ", " + value));
                }
                if (!name.startsWith(KEY_NAME_PREFIX)) continue;
                payloadName = name.substring(KEY_NAME_PREFIX.length());
                value = from.getString(name);
                this.names.put(payloadName, value);
                logger.debug((Object)("Unmarshalled " + name + " -> " + payloadName + ", " + value));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        try {
            String idString;
            String key;
            for (String name : this.ids.keySet()) {
                key = KEY_ID_PREFIX + name;
                idString = this.ids.get(name);
                mapMessage.setString(key, idString);
                logger.debug((Object)("Marshalled " + name + " -> " + key + " " + idString));
            }
            for (String name : this.names.keySet()) {
                key = KEY_NAME_PREFIX + name;
                idString = this.names.get(name);
                mapMessage.setString(key, idString);
                logger.debug((Object)("Marshalled " + name + " -> " + key + " " + idString));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addPayload(String key, String id, String name) {
        this.ids.put(key, id);
        this.names.put(key, name);
    }

    public String getId(String key) {
        if (this.ids.containsKey(key)) {
            return this.ids.get(key);
        }
        throw new IllegalArgumentException("No payload with name: " + key);
    }

    public String getName(String key) {
        if (this.names.containsKey(key)) {
            return this.names.get(key);
        }
        throw new IllegalArgumentException("No payload with name: " + key);
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.ids.keySet());
        keys.addAll(this.names.keySet());
        return keys;
    }

    @Override
    public String toString() {
        return super.toString() + ", payload count: " + this.getKeys().size();
    }
}

