/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.AuthCancelledException;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.util.concurrent.CountDownLatch;

public class FirstLoginListener
extends TempTopicMessagingListenerBase {
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cancelled = false;

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        if (msg instanceof AuthenticationMessage && ((AuthenticationMessage)msg).isLoginAck()) {
            this.latch.countDown();
        }
    }

    public void waitForReply() throws AuthCancelledException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUp();
        }
        if (this.cancelled) {
            throw new AuthCancelledException();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.latch.countDown();
    }
}

