/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.ChecksumParseException;
import fi.csc.microarray.filebroker.ContentLengthException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Md5FileUtils {
    private static final String DELIMITER = "  ";
    private static final String NEW_LINE = "\n";
    private static final int MD5_LENGTH = 32;

    public static void writeMd5(String md5, File dataFile) throws IOException {
        File md5File = Md5FileUtils.getMd5File(dataFile);
        File tempFile = File.createTempFile(md5File.getName(), null, md5File.getParentFile());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "utf-8"));){
            String line = md5 + DELIMITER + dataFile.getName() + NEW_LINE;
            writer.write(line);
            if (!tempFile.renameTo(md5File)) {
                tempFile.delete();
                if (!line.equals(Md5FileUtils.readMd5(dataFile))) {
                    throw new IOException("rename failed");
                }
            }
        }
        catch (ChecksumParseException e) {
            throw new IOException("rename and read failed", e);
        }
    }

    public static String readMd5WithoutParseException(File dataFile) throws IOException {
        String md5 = null;
        try {
            md5 = Md5FileUtils.readMd5(dataFile);
        }
        catch (ChecksumParseException checksumParseException) {
            // empty catch block
        }
        return md5;
    }

    public static String readMd5(File dataFile) throws ChecksumParseException, IOException {
        File md5File = Md5FileUtils.getMd5File(dataFile);
        if (!md5File.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(md5File), "utf-8"));){
            String line = reader.readLine();
            String[] parts = line.split(DELIMITER);
            if (parts.length != 2) {
                throw new ChecksumParseException("md5 file " + dataFile + " is corrupted, not two strings: " + line);
            }
            if (parts[0].length() != 32) {
                throw new ChecksumParseException("md5 file " + dataFile + " is corrupted, md5 length: " + parts[0].length() + ", " + 32 + " expected (" + line + ")");
            }
            String string = parts[0];
            return string;
        }
    }

    static File getMd5File(File file) {
        return new File(file.getAbsolutePath() + ".md5");
    }

    public static void removeMd5(File dataFile) {
        File md5File = Md5FileUtils.getMd5File(dataFile);
        md5File.delete();
    }

    public static String calculateMd5(File file) throws IOException {
        BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));
        try (ChecksumInputStream md5Stream = new ChecksumInputStream((InputStream)fileStream, true);){
            while (md5Stream.read(new byte[0x100000]) != -1) {
            }
            String string = md5Stream.getChecksum();
            return string;
        }
    }

    public static void verify(String checksum1, String checksum2) throws ChecksumException {
        if (Md5FileUtils.equalsOrNull(checksum1, checksum2)) {
            return;
        }
        throw new ChecksumException();
    }

    public static void verify(String checksum1, String checksum2, String checksum3) throws ChecksumException {
        if (Md5FileUtils.equalsOrNull(checksum1, checksum2, checksum3)) {
            return;
        }
        throw new ChecksumException();
    }

    public static boolean equalsOrNull(String checksum1, String checksum2, String checksum3) {
        return Md5FileUtils.equalsOrNull(checksum1, checksum2) && Md5FileUtils.equalsOrNull(checksum2, checksum3) && Md5FileUtils.equalsOrNull(checksum1, checksum3);
    }

    public static boolean equalsOrNull(String checksum1, String checksum2) {
        if (checksum1 != null && checksum2 != null) {
            return checksum1.equals(checksum2);
        }
        return true;
    }

    public static void verify(Long long1, Long long2) throws ContentLengthException {
        if (Md5FileUtils.equalsOrNull(long1, long2)) {
            return;
        }
        throw new ContentLengthException();
    }

    public static void verify(Long long1, Long long2, Long long3) throws ContentLengthException {
        if (Md5FileUtils.equalsOrNull(long1, long2, long3)) {
            return;
        }
        throw new ContentLengthException();
    }

    public static boolean equalsOrNull(Long long1, Long long2, Long long3) {
        return Md5FileUtils.equalsOrNull(long1, long2) && Md5FileUtils.equalsOrNull(long2, long3) && Md5FileUtils.equalsOrNull(long1, long3);
    }

    public static boolean equalsOrNull(Long long1, Long long2) {
        if (long1 != null && long2 != null) {
            return long1.equals(long2);
        }
        return true;
    }
}

