/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.MessagingTestBase;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.security.CryptoKey;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBrokerClientTest
extends MessagingTestBase {
    private FileBrokerClient fbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fbc = new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE));
    }

    @Override
    @Before
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testFileBroker() throws FileNotFoundException, FileBrokerException, JMSException, IOException {
        File file = new File("src/test/resources/affy_example.cel");
        System.out.println("Adding file");
        String dataId = CryptoKey.generateRandom();
        this.fbc.addFile(dataId, FileBrokerClient.FileBrokerArea.CACHE, new FileInputStream(file), file.length(), null);
        System.out.println("Checking file");
        System.out.println("Getting file");
        long outputContentLength = 0L;
        BufferedInputStream input = new BufferedInputStream(this.fbc.getInputStream(dataId));
        while (input.read() != -1) {
            ++outputContentLength;
        }
        IOUtils.closeIfPossible(input);
        Assert.assertEquals((long)file.length(), (long)outputContentLength);
    }
}

