/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.ChecksumParseException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.Md5FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileBrokerAreas {
    private File cacheRoot;
    private File storageRoot;

    public FileBrokerAreas(File repositoryRoot, String cachePath, String storagePath) {
        this.cacheRoot = new File(repositoryRoot, cachePath);
        this.storageRoot = new File(repositoryRoot, storagePath);
    }

    public Long getSize(String fileId, FileBrokerClient.FileBrokerArea area) {
        if (this.fileExists(fileId, area)) {
            return this.getFile(fileId, area).length();
        }
        return null;
    }

    public boolean fileExists(String fileId, FileBrokerClient.FileBrokerArea area) {
        return this.getFile(fileId, area).exists();
    }

    private File getFile(String fileId, FileBrokerClient.FileBrokerArea area) {
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId)) {
            throw new IllegalArgumentException("illegal file id: " + fileId);
        }
        switch (area) {
            case CACHE: {
                File cacheFile = new File(this.cacheRoot, fileId);
                return cacheFile;
            }
            case STORAGE: {
                File storageFile = new File(this.storageRoot, fileId);
                return storageFile;
            }
        }
        throw new IllegalArgumentException("illegal filebroker area: " + (Object)((Object)area));
    }

    public boolean moveFromCacheToStorage(String fileId) throws IOException {
        if (!AuthorisedUrlRepository.checkFilenameSyntax(fileId)) {
            throw new IllegalArgumentException("illegal file id: " + fileId);
        }
        File cacheFile = new File(this.cacheRoot, fileId);
        File storageFile = new File(this.storageRoot, fileId);
        return this.renameDataFile(cacheFile, storageFile);
    }

    private boolean renameDataFile(File sourceDataFile, File destDataFile) throws IOException {
        boolean copyChecksum;
        File sourceMd5File = Md5FileUtils.getMd5File(sourceDataFile);
        File destMd5File = Md5FileUtils.getMd5File(destDataFile);
        boolean sameDirectory = sourceDataFile.getParentFile().getAbsoluteFile().equals(destDataFile.getParentFile().getAbsoluteFile());
        boolean bl = copyChecksum = sourceMd5File.exists() && !sameDirectory;
        if (copyChecksum) {
            FileUtils.copyFile((File)sourceMd5File, (File)destMd5File);
        }
        boolean renameSuccess = sourceDataFile.renameTo(destDataFile);
        if (copyChecksum) {
            if (renameSuccess) {
                sourceMd5File.delete();
            } else {
                destMd5File.delete();
            }
        }
        return renameSuccess;
    }

    public String getChecksum(String fileId, FileBrokerClient.FileBrokerArea area) throws ChecksumParseException, IOException {
        return Md5FileUtils.readMd5(this.getFile(fileId, area));
    }
}

